/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.http;

import com.google.gson.Gson;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;

public class HTTPDao {
    protected Client client = ClientBuilder.newClient();
    protected String host;
    protected String authorizationHeaderValue = null;
    protected final Gson gson = new Gson();

    public HTTPDao(String host) {
        this.host = host;
    }

    public String getAuthorizationHeaderValue() {
        return this.authorizationHeaderValue;
    }

    public HTTPDao setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    protected <T> T get(String path, String mediaType, Class<T> c) {
        try (Response response = this.get(path, mediaType);){
            Object object = response.readEntity(c);
            return (T)object;
        }
    }

    public Response get(String path, String mediaType) {
        String url = this.host + path;
        return this.client.target(url).request().header("Authorization", (Object)this.getAuthorizationHeaderValue()).accept(new String[]{mediaType}).get();
    }

    public String getAsString(String path, String mediaType) {
        return this.get(path, mediaType, String.class);
    }

    protected <T> T post(String path, String mediaType, Class<T> c, Object requestEntity) {
        try (Response response = this.post(path, mediaType, requestEntity);){
            Object object = response.readEntity(c);
            return (T)object;
        }
    }

    public Response post(String path, String mediaType, Object requestEntity) {
        String url = this.host + path;
        return this.client.target(url).request().header("Authorization", (Object)this.getAuthorizationHeaderValue()).post(Entity.entity((Object)requestEntity, (String)mediaType));
    }

    public String postAsString(String path, String mediaType, Object requestEntity) {
        return this.post(path, mediaType, String.class, requestEntity);
    }

    protected <T> T put(String path, String mediaType, Class<T> c, Object requestEntity) {
        try (Response response = this.put(path, mediaType, requestEntity);){
            Object object = response.readEntity(c);
            return (T)object;
        }
    }

    public Response put(String path, String mediaType, Object requestEntity) {
        String url = this.host + path;
        return this.client.target(url).request().header("Authorization", (Object)this.getAuthorizationHeaderValue()).put(Entity.entity((Object)requestEntity, (String)mediaType));
    }

    public String putAsString(String path, String mediaType, Object requestEntity) {
        return this.put(path, mediaType, String.class, requestEntity);
    }

    protected <T> T delete(String path, String mediaType, Class<T> c) {
        try (Response response = this.delete(path, mediaType);){
            Object object = response.readEntity(c);
            return (T)object;
        }
    }

    public Response delete(String path, String mediaType) {
        String url = this.host + path;
        return this.client.target(url).request().header("Authorization", (Object)this.getAuthorizationHeaderValue()).accept(new String[]{mediaType}).delete();
    }

    public String deleteAsString(String path, String mediaType) {
        return this.delete(path, mediaType, String.class);
    }
}

