/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.net.http;

import de.qytera.qtaf.core.net.http.HTTPJsonDao;

public abstract class HTTPJsonEntityRepository<T> {
    protected HTTPJsonDao dao;
    protected String path;
    protected Class<T> entityClass;

    public HTTPJsonEntityRepository(HTTPJsonDao dao, String path, Class<T> entityClass) {
        this.dao = dao;
        this.path = path;
        this.entityClass = entityClass;
    }

    public String buildItemPath(int id) {
        return this.path + "/" + id;
    }

    public String buildItemPath(String id) {
        return this.path + "/" + id;
    }

    public abstract String buildItemPath(T var1);

    public T findOne(int id) {
        return this.dao.get(this.buildItemPath(id), this.entityClass);
    }

    public T createOne(T entity) {
        return this.dao.post(this.path, this.entityClass, entity);
    }

    public T updateOne(T entity) {
        return this.dao.put(this.buildItemPath(entity), this.entityClass, entity);
    }

    public T deleteOne(T entity) {
        return this.dao.delete(this.buildItemPath(entity), this.entityClass);
    }
}

