/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.net.http;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

public class HTTPDao {
    protected Client client = new Client();
    protected String host;
    protected String authorizationHeaderValue = null;
    protected final Gson gson = new Gson();

    public HTTPDao(String host) {
        this.host = host;
    }

    public String getAuthorizationHeaderValue() {
        return this.authorizationHeaderValue;
    }

    public HTTPDao setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    protected <T> T get(String path, String mediaType, Class<T> c) {
        String url = this.host + path;
        return (T)((WebResource.Builder)((WebResource.Builder)this.client.resource(url).getRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeaderValue())).type(mediaType)).get(c);
    }

    public ClientResponse get(String path, String mediaType) {
        return this.get(path, mediaType, ClientResponse.class);
    }

    public String getAsString(String path, String mediaType) {
        return this.get(path, mediaType, String.class);
    }

    protected <T> T post(String path, String mediaType, Class<T> c, Object requestEntity) {
        String url = this.host + path;
        return (T)((WebResource.Builder)((WebResource.Builder)this.client.resource(url).getRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeaderValue())).type(mediaType)).post(c, requestEntity);
    }

    public ClientResponse post(String path, String mediaType, Object requestEntity) {
        return this.post(path, mediaType, ClientResponse.class, requestEntity);
    }

    public String postAsString(String path, String mediaType, Object requestEntity) {
        return this.post(path, mediaType, String.class, requestEntity);
    }

    protected <T> T put(String path, String mediaType, Class<T> c, Object requestEntity) {
        String url = this.host + path;
        return (T)((WebResource.Builder)((WebResource.Builder)this.client.resource(url).getRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeaderValue())).type(mediaType)).put(c, requestEntity);
    }

    public ClientResponse put(String path, String mediaType, Object requestEntity) {
        return this.put(path, mediaType, ClientResponse.class, requestEntity);
    }

    public String putAsString(String path, String mediaType, Object requestEntity) {
        return this.put(path, mediaType, String.class, requestEntity);
    }

    protected <T> T delete(String path, String mediaType, Class<T> c) {
        String url = this.host + path;
        return (T)((WebResource.Builder)((WebResource.Builder)this.client.resource(url).getRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeaderValue())).type(mediaType)).delete(c);
    }

    public ClientResponse delete(String path, String mediaType) {
        return this.delete(path, mediaType, ClientResponse.class);
    }

    public String deleteAsString(String path, String mediaType) {
        return this.delete(path, mediaType, String.class);
    }
}

