/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.entity;

import de.qytera.qtaf.core.util.TokenSeparatedStringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QTAFCucumberScenarioEntity {
    private static final String GROUPS_TAG_NAME = "Groups";
    private static final String TEST_SET_TAG_NAME = "TestSet";
    private String featureName = "";
    private Map<String, String> featureTags = new HashMap<String, String>();
    private String scenarioName = "";
    private Map<String, List<String>> scenarioTags = new HashMap<String, List<String>>();
    private List<String> groupNames = new ArrayList<String>();
    private List<String> testSets = new ArrayList<String>();

    public String getFeatureName() {
        return this.featureName;
    }

    public QTAFCucumberScenarioEntity setFeatureName(String featureName) {
        this.featureName = featureName;
        return this;
    }

    public String getFeatureTag(String key) {
        return this.featureTags.get(key);
    }

    public Map<String, String> getFeatureTags() {
        return this.featureTags;
    }

    public boolean hasFeatureTag(String key) {
        return this.featureTags.get(key) != null;
    }

    public void addFeatureTag(String key, String value) {
        this.featureTags.put(key, value);
    }

    public QTAFCucumberScenarioEntity setFeatureTags(Map<String, String> featureTags) {
        this.featureTags = featureTags;
        return this;
    }

    public void removeFeatureTag(String key) {
        this.featureTags.remove(key);
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public QTAFCucumberScenarioEntity setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
        return this;
    }

    public List<String> getScenarioTag(String key) {
        return this.scenarioTags.get(key);
    }

    public Map<String, List<String>> getScenarioTags() {
        return this.scenarioTags;
    }

    public boolean hasScenarioTag(String key) {
        return this.scenarioTags.get(key) != null;
    }

    public void addScenarioTag(String key, String value) {
        this.addScenarioTag(key, Stream.of(value).collect(Collectors.toCollection(ArrayList::new)));
    }

    public void addScenarioTag(String key, List<String> values) {
        if (this.scenarioTags.get(key) != null) {
            this.scenarioTags.get(key).addAll(values);
        } else {
            this.scenarioTags.put(key, values);
        }
    }

    public QTAFCucumberScenarioEntity setScenarioTags(Map<String, List<String>> scenarioTags) {
        this.scenarioTags = scenarioTags;
        return this;
    }

    public void removeScenarioTag(String key) {
        this.scenarioTags.remove(key);
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public void addGroupName(String groupName) {
        this.groupNames.add(groupName);
    }

    public void setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
    }

    public boolean hasGroupName(String groupName) {
        return this.groupNames.contains(groupName);
    }

    public boolean hasAllGroupNames(List<String> names) {
        for (String name : names) {
            if (this.hasGroupName(name)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyGroupName(List<String> names) {
        for (String name : names) {
            if (!this.hasGroupName(name)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTestSets() {
        return this.testSets;
    }

    public void addTestSet(String testSet) {
        this.testSets.add(testSet);
    }

    public QTAFCucumberScenarioEntity setTestSet(List<String> testSets) {
        this.testSets = testSets;
        return this;
    }

    public void removeTestSet(String testSet) {
        this.testSets.remove(testSet);
    }

    public boolean belongsToTestSet(String testSet) {
        return this.testSets.contains(testSet);
    }

    public boolean belongsToAnyTestSet(List<String> testSets) {
        for (String name : testSets) {
            if (!this.belongsToTestSet(name)) continue;
            return true;
        }
        return false;
    }

    public boolean belongsToAllTestSets(List<String> names) {
        for (String name : names) {
            if (this.belongsToTestSet(name)) continue;
            return false;
        }
        return true;
    }

    public void removeGroupName(String groupName) {
        this.groupNames.remove(groupName);
    }

    public QTAFCucumberScenarioEntity parseGroupTags() {
        List<String> tagGroupsStrings = this.getScenarioTags().get(GROUPS_TAG_NAME);
        if (tagGroupsStrings == null) {
            return this;
        }
        for (String value : tagGroupsStrings) {
            this.groupNames.addAll(TokenSeparatedStringHelper.toList(value, ",", true));
        }
        return this;
    }

    public void parseTestSetTags() {
        List<String> testSetTagValues = this.getScenarioTags().get(TEST_SET_TAG_NAME);
        if (testSetTagValues == null) {
            return;
        }
        for (String value : testSetTagValues) {
            this.testSets.addAll(TokenSeparatedStringHelper.toList(value, ",", true));
        }
    }
}

