/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium;

import com.codeborne.selenide.WebDriverRunner;
import com.google.inject.Provides;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.error.DriverInitializationError;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.reflection.ClassLoader;
import de.qytera.qtaf.core.selenium.AbstractDriver;
import de.qytera.qtaf.core.selenium.helper.SeleniumDriverConfigHelper;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.openqa.selenium.WebDriver;

public class DriverFactory {
    private static WebDriver driver;
    private static final ErrorLogCollection errorLogCollection;
    private static final ConfigMap config;
    private static final Logger LOGGER;

    @Provides
    public static WebDriver getDriver() {
        String driverName = config.getString("driver.name", "chrome");
        WebDriver driver = DriverFactory.getDriver(driverName);
        WebDriverRunner.setWebDriver((WebDriver)driver);
        return driver;
    }

    @Provides
    public static WebDriver getDriver(String driverName) {
        if (driver != null) {
            return driver;
        }
        Object[] lst = ClassLoader.getInstancesOfDirectSubtypesOf(AbstractDriver.class);
        AbstractDriver d = null;
        try {
            for (Object o : lst) {
                d = (AbstractDriver)o;
                if (d.getName() == null || !d.getName().equals(driverName)) continue;
                driver = d.getDriverInstance();
                break;
            }
        }
        catch (Exception e) {
            errorLogCollection.addErrorLog(new DriverInitializationError(e));
            QtafEvents.afterDriverInitialization.onError((Throwable)e);
            DriverFactory.logError("Error: Driver initialization failed");
            e.printStackTrace();
            System.exit(1);
        }
        DriverFactory.logInfo("Use driver " + driverName);
        if (driver != null) {
            DriverFactory.logInfo("Driver initialized: " + driverName);
            QtafEvents.afterDriverInitialization.onNext((Object)d);
        } else {
            DriverFactory.logError("Driver could not be initialized");
        }
        return DriverFactory.configureDriver(driver);
    }

    @Provides
    public static WebDriver getDriver(boolean restart) {
        if (driver != null) {
            driver.quit();
            driver = null;
        }
        return DriverFactory.getDriver();
    }

    protected static WebDriver configureDriver(WebDriver d) {
        assert (driver != null);
        d.manage().timeouts().implicitlyWait((long)SeleniumDriverConfigHelper.getImplicitTimeout(), TimeUnit.SECONDS);
        DriverFactory.logInfo("Driver configured");
        return d;
    }

    @Provides
    public static WebDriver restartDriver(String driverName) {
        if (driver != null) {
            driver.quit();
            driver = null;
        }
        return DriverFactory.getDriver(driverName);
    }

    public static void clearDriver() {
        driver = null;
    }

    public static boolean driverHasQuit() {
        return driver != null && driver.toString().contains("(null)");
    }

    private static void logInfo(String message) {
        LOGGER.info("[DriverFactory] " + message, new Object[0]);
    }

    private static void logError(String message) {
        LOGGER.error("[DriverFactory] " + message, new Object[0]);
    }

    @Generated
    private DriverFactory() {
    }

    static {
        errorLogCollection = ErrorLogCollection.getInstance();
        config = QtafFactory.getConfiguration();
        LOGGER = QtafFactory.getLogger();
    }
}

