/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class FieldHelper {
    private FieldHelper() {
    }

    public static List<Field> getDeclaredFieldsRecursively(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        FieldHelper.getDeclaredFieldsRecursively(fields, clazz);
        return fields;
    }

    private static void getDeclaredFieldsRecursively(ArrayList<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            FieldHelper.getDeclaredFieldsRecursively(fields, clazz.getSuperclass());
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = FieldHelper.getFieldByName(fieldName, object.getClass());
        if (field == null) {
            return null;
        }
        return FieldHelper.getFieldValue(object, field);
    }

    public static Field getFieldByName(String name, Class<?> clazz) {
        List<Field> fields = FieldHelper.getDeclaredFieldsRecursively(clazz);
        Optional<Field> fieldOptional = fields.stream().filter(field -> field.getName().equals(name)).findAny();
        return fieldOptional.orElse(null);
    }

    public static boolean canAccess(Field field, Object object) throws IllegalArgumentException {
        return field.canAccess(object);
    }

    public static Object getFieldValue(Object object, Field field) {
        try {
            boolean accessible = field.canAccess(object);
            field.setAccessible(true);
            Object value = field.get(object);
            field.setAccessible(accessible);
            return value;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static boolean setFieldValue(Object object, Field field, Object value) {
        try {
            boolean accessible = field.canAccess(object);
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(accessible);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static boolean setFieldValue(Object object, String fieldName, Object value) {
        Field field = FieldHelper.getFieldByName(fieldName, object.getClass());
        assert (field != null);
        try {
            boolean accessible = field.canAccess(object);
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(accessible);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }
}

