/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.reflection;

import com.google.gson.JsonElement;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.gson.GsonFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ClassLoader {
    private static final List<String> packageNames = new ArrayList<String>(Collections.singletonList("de.qytera.qtaf"));
    private static final Map<String, Object> instancesByClassName = new HashMap<String, Object>();
    private static final Map<Type, Object[]> instancesByType = new HashMap<Type, Object[]>();

    private ClassLoader() {
    }

    public static void addPackageName(String packageName) {
        if (!packageNames.contains(packageName)) {
            packageNames.add(packageName);
        }
    }

    public static boolean hasPackageName(String packageName) {
        return packageNames.contains(packageName);
    }

    public static boolean removePackageName(String packageName) {
        if (ClassLoader.hasPackageName(packageName)) {
            return packageNames.remove(packageName);
        }
        return false;
    }

    public static Set<Class<?>> getSubTypesOfRecursively(Class<?> clazz, Set<Class<?>> classes, List<String> packageNames) {
        if (classes == null) {
            classes = new HashSet();
        }
        if (packageNames == null) {
            packageNames = List.of();
        }
        Set<Class<?>> newClasses = ClassLoader.getSubTypesOf(clazz, packageNames);
        classes.addAll(newClasses);
        for (Class<?> subClass : newClasses) {
            classes.addAll(ClassLoader.getSubTypesOfRecursively(subClass, classes, packageNames));
        }
        return classes;
    }

    public static Set<Class<?>> getSubTypesOf(Class<?> clazz, List<String> packageNames) {
        if (packageNames != null) {
            for (String packageName : packageNames) {
                ClassLoader.addPackageName(packageName);
            }
        }
        HashSet classes = new HashSet();
        if (packageNames != null) {
            for (String packageName : packageNames) {
                try {
                    Reflections ref = new Reflections(packageName, new Scanner[0]);
                    classes.addAll(ref.getSubTypesOf(clazz));
                }
                catch (Exception exception) {}
            }
        }
        return classes;
    }

    public static Set<Class<?>> getSubTypesOf(Class<?> clazz) {
        ConfigMap configMap = QtafFactory.getConfiguration();
        List<JsonElement> packageNames = configMap.getList("framework.packageNames");
        String testsPackage = configMap.getString("tests.package", "de.qytera.qtaf");
        packageNames.add(GsonFactory.getInstanceWithoutCustomSerializers().toJsonTree((Object)testsPackage));
        packageNames.stream().map(JsonElement::getAsString).forEach(ClassLoader::addPackageName);
        return ClassLoader.getSubTypesOf(clazz, ClassLoader.packageNames);
    }

    public static Object[] getInstancesOfDirectSubtypesOf(Class<?> clazz) {
        if (instancesByType.get(clazz) != null) {
            return instancesByType.get(clazz);
        }
        Set<Class<?>> classes = ClassLoader.getSubTypesOf(clazz);
        ArrayList<Object> newInstancesByType = new ArrayList<Object>();
        for (Class<?> c : classes) {
            try {
                if (instancesByClassName.get(c.getName()) == null) {
                    Object newInstance = ClassLoader.getInstance(c);
                    if (newInstance == null) continue;
                    instancesByClassName.put(c.getName(), newInstance);
                    newInstancesByType.add(newInstance);
                    continue;
                }
                newInstancesByType.add(instancesByClassName.get(c.getName()));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        instancesByType.put(clazz, newInstancesByType.toArray());
        return newInstancesByType.toArray();
    }

    public static Object getInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        if (Modifier.isAbstract(c.getModifiers())) {
            return null;
        }
        return constructor.newInstance(new Object[0]);
    }
}

