/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.collection;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TestSuiteLogCollection {
    private static TestSuiteLogCollection instance = new TestSuiteLogCollection();
    private final UUID uuid = UUID.randomUUID();
    private SuiteInfo suiteInfo = new SuiteInfo();
    private final SystemInfo systemInfo = new SystemInfo();
    private final ProcessInfo processInfo = new ProcessInfo();
    private final ThreadInfo threadInfo = new ThreadInfo();
    private String osName = System.getProperty("os.name");
    private String driverName = "";
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Date start = new Date();
    private Date end = new Date();
    private long duration = 0L;
    private String logDirectory = null;
    private final List<TestFeatureLogCollection> testFeatureLogCollections = Collections.synchronizedList(new ArrayList());

    private TestSuiteLogCollection() {
        this.buildLogDirectoryPath();
    }

    public static synchronized TestSuiteLogCollection getInstance() {
        return instance;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void resetLogDirectory() {
        this.logDirectory = null;
    }

    public TestSuiteLogCollection buildLogDirectoryPath() {
        if (this.logDirectory == null && this.getDriverName() != null && !this.getDriverName().isBlank() && !this.getDriverName().equals("none")) {
            SimpleDateFormat dirDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat dirHourFormatter = new SimpleDateFormat("HH-mm-ss");
            this.logDirectory = DirectoryHelper.preparePath((String)("$USER_DIR/logs/" + dirDateFormatter.format(this.start) + "/" + dirHourFormatter.format(this.start) + "-" + this.getDriverName() + "-" + this.uuid));
        }
        return this;
    }

    public synchronized List<TestFeatureLogCollection> getTestFeatureLogCollections() {
        return this.testFeatureLogCollections;
    }

    public synchronized void clearCollection() {
        this.testFeatureLogCollections.clear();
        this.setDriverName("none");
        this.setStart(new Date());
        this.resetLogDirectory();
    }

    public synchronized TestSuiteLogCollection addTestClassLogCollection(TestFeatureLogCollection collection) {
        if (!this.testFeatureLogCollections.contains(collection)) {
            this.testFeatureLogCollections.add(collection);
        }
        return this;
    }

    public synchronized TestFeatureLogCollection createFeatureIfNotExists(String featureId, String featureName) {
        TestFeatureLogCollection collection = TestFeatureLogCollection.createFeatureLogCollectionIfNotExists(featureId, featureName);
        if (!this.testFeatureLogCollections.contains(collection)) {
            this.testFeatureLogCollections.add(collection);
            QtafFactory.getLogger().debug(String.format("Added Feature log: feature_id=%s, name=%s, size=%s, suite_hash=%s, feature_hash=%s", featureId, featureName, this.testFeatureLogCollections.size(), this.hashCode(), collection.hashCode()), new Object[0]);
        }
        return collection;
    }

    public synchronized void setInstance(TestSuiteLogCollection instance) {
        TestSuiteLogCollection.instance = instance;
    }

    public SuiteInfo getSuiteInfo() {
        return this.suiteInfo;
    }

    public TestSuiteLogCollection setSuiteInfo(SuiteInfo suiteInfo) {
        this.suiteInfo = suiteInfo;
        return this;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public String getOsName() {
        return this.osName;
    }

    public TestSuiteLogCollection setOsName(String osName) {
        this.osName = osName;
        return this;
    }

    public String getDriverName() {
        if (this.driverName == null || this.driverName.isBlank()) {
            return "none";
        }
        return this.driverName;
    }

    public TestSuiteLogCollection setDriverName(String driverName) {
        this.driverName = driverName;
        this.buildLogDirectoryPath();
        return this;
    }

    public Date getStart() {
        return this.start;
    }

    public TestSuiteLogCollection setStart(Date start) {
        this.start = start;
        return this;
    }

    public Date getEnd() {
        if (this.end == null) {
            this.end = new Date();
        }
        return this.end;
    }

    public TestSuiteLogCollection setEnd(Date end) {
        this.end = end;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public TestSuiteLogCollection setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public int countFeatureLogs() {
        return this.testFeatureLogCollections.size();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getTag(String key) {
        return this.tags.get(key);
    }

    public void addTag(String key, String value) {
        this.tags.put(key, value);
    }

    public void removeTag(String key) {
        this.tags.remove(key);
    }

    public void clear() {
        this.start = null;
        this.end = null;
        this.duration = 0L;
        this.driverName = null;
        this.clearCollection();
        this.suiteInfo.name = null;
        this.suiteInfo.outputDir = null;
        this.tags.clear();
    }

    public class SuiteInfo {
        private String name = "";
        private String outputDir;

        public String getName() {
            return this.name;
        }

        public SuiteInfo setName(String name) {
            this.name = name;
            return this;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public SuiteInfo setOutputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }
    }

    public class SystemInfo {
        private String osName = System.getProperty("os.name");
        private String javaVersion = System.getProperty("java.version");
        private String userDir = System.getProperty("user.dir");

        public String getOsName() {
            return this.osName;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public SystemInfo setJavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }

        public String getUserDir() {
            return this.userDir;
        }

        public SystemInfo setUserDir(String userDir) {
            this.userDir = userDir;
            return this;
        }
    }

    public static class ProcessInfo {
        private long pid = ProcessHandle.current().pid();

        ProcessInfo() {
        }

        public long getPid() {
            return this.pid;
        }
    }

    public class ThreadInfo {
        private long threadId = Thread.currentThread().getId();
        private String threadName = Thread.currentThread().getName();

        public long getThreadId() {
            return this.threadId;
        }

        public ThreadInfo setThreadId(long threadId) {
            this.threadId = threadId;
            return this;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public ThreadInfo setThreadName(String threadName) {
            this.threadName = threadName;
            return this;
        }
    }
}

