/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.guice.method_interceptor;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.annotations.TestFeature;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.guice.invokation.AbstractStepExecutionInfo;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import java.lang.annotation.Annotation;
import java.util.Date;
import org.aopalliance.intercept.MethodInvocation;

public interface AbstractTestNGAnnotatedMethodInterceptor<T extends AbstractStepExecutionInfo> {
    public T buildStepExecutionInfoEntity(MethodInvocation var1);

    public Annotation getAnnotation(MethodInvocation var1);

    public String buildScenarioName(String var1, String var2);

    public String buildScenarioDescription(String var1, String var2);

    default public TestFeatureLogCollection buildFeatureLogCollection(MethodInvocation methodInvocation, Object instance) {
        String featureId = methodInvocation.getMethod().getDeclaringClass().getName();
        String featureName = methodInvocation.getMethod().getDeclaringClass().getAnnotation(TestFeature.class).name();
        return QtafFactory.getTestSuiteLogCollection().createFeatureIfNotExists(featureId, featureName);
    }

    default public TestScenarioLogCollection buildScenarioLogCollection(TestFeatureLogCollection featureLogCollection, MethodInvocation methodInvocation, Object instance) {
        String featureId = featureLogCollection.getFeatureId();
        String featureName = featureLogCollection.getFeatureName();
        String scenarioId = featureId + "." + methodInvocation.getMethod().getName();
        String scenarioName = this.buildScenarioName(featureName, scenarioId);
        String scenarioDescription = this.buildScenarioDescription(featureName, scenarioName);
        TestScenarioLogCollection scenarioLogCollection = TestScenarioLogCollection.createTestScenarioLogCollection(featureId, scenarioId, "", scenarioName);
        scenarioLogCollection.setDescription(scenarioDescription);
        scenarioLogCollection.setAnnotations(methodInvocation.getMethod().getAnnotations());
        featureLogCollection.addScenarioLogCollection(scenarioLogCollection);
        return scenarioLogCollection;
    }

    default public void updateTestContextWithLogCollection(IQtafTestContext instance, TestScenarioLogCollection scenarioLogCollection) {
        instance.setLogCollection(scenarioLogCollection);
        instance.addLoggerToFieldsRecursively();
    }

    default public Object executeStepMethod(MethodInvocation methodInvocation, TestScenarioLogCollection scenarioLogCollection) throws Throwable {
        scenarioLogCollection.setStart(new Date());
        Object result = methodInvocation.proceed();
        scenarioLogCollection.setEnd(new Date());
        scenarioLogCollection.setDuration(scenarioLogCollection.getDuration());
        scenarioLogCollection.setStatus(TestScenarioLogCollection.Status.SUCCESS);
        return result;
    }

    default public void handleStepExecutionFailure(TestScenarioLogCollection scenarioLogCollection) {
        scenarioLogCollection.setEnd(new Date());
        scenarioLogCollection.setDuration(scenarioLogCollection.getDuration());
        scenarioLogCollection.setStatus(TestScenarioLogCollection.Status.FAILURE);
    }
}

