/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.event_subscriber.step;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.console.ConsoleColors;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.guice.annotations.Step;
import de.qytera.qtaf.core.guice.invokation.StepExecutionInfo;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.AssertionLogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.core.selenium.DriverFactory;
import de.qytera.qtaf.core.selenium.helper.SeleniumDriverConfigHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class StepLoggerSubscriber
implements IEventSubscriber {
    private final Map<Integer, StepInformationLogMessage> stepIdLogMap = new HashMap<Integer, StepInformationLogMessage>();
    private final Logger logger = QtafFactory.getLogger();

    @Override
    public void initialize() {
        QtafEvents.beforeStepExecution.subscribe(this::onBeforeStepExecution);
        QtafEvents.stepExecutionSuccess.subscribe(this::onStepExecutionSuccess);
        QtafEvents.stepExecutionFailure.subscribe(this::onStepExecutionFailure);
    }

    private void onBeforeStepExecution(StepExecutionInfo stepExecutionInfo) {
        this.log(stepExecutionInfo, "started");
        MethodInvocation methodInvocation = stepExecutionInfo.getMethodInvocation();
        IQtafTestContext context = (IQtafTestContext)methodInvocation.getThis();
        assert (context != null);
        String className = context.getClass().getName().replace("$$EnhancerByGuice$$", "").replaceAll("[A-Fa-f0-9]+$", "");
        Step step = methodInvocation.getMethod().getAnnotation(Step.class);
        StepInformationLogMessage logMessage = new StepInformationLogMessage(className + "." + methodInvocation.getMethod().getName(), "Step " + step.name() + " executed").setStep(step).setStart(new Date());
        stepExecutionInfo.setLogMessage(logMessage);
        if (SeleniumDriverConfigHelper.shouldTakeScreenshotsBeforeStep()) {
            String screenshotFilePath = this.stepExecutionScreenshot(stepExecutionInfo, "before", logMessage.getUuid());
            logMessage.setScreenshotBefore(screenshotFilePath);
        }
        this.stepIdLogMap.put(stepExecutionInfo.getId(), logMessage);
        if (context.getLogCollection() == null) {
            throw new AssertionError((Object)"The LogCollection of the context class was not initialized properly.\nYou may check the following points:\n\t- All your methods that are annotated with @Test, @BeforeXXX, @AfterXXX must be public\n\t- If classes overwrite initialize() the parent method must be called first\n\t- load() must not be called in the constructor or in class attributes but in the initialize() method");
        }
        context.getLogCollection().addLogMessage(logMessage);
        Parameter[] params = methodInvocation.getMethod().getParameters();
        Object[] args = methodInvocation.getArguments();
        for (int i = 0; i < params.length; ++i) {
            logMessage.addStepParameter(params[i].getName(), args[i]);
        }
    }

    private void onStepExecutionSuccess(StepExecutionInfo stepExecutionInfo) {
        this.log(stepExecutionInfo, ConsoleColors.green("success"));
        StepInformationLogMessage logMessage = this.stepIdLogMap.get(stepExecutionInfo.getId());
        logMessage.setResult(stepExecutionInfo.getResult());
        if (SeleniumDriverConfigHelper.shouldTakeScreenshotsAfterStep()) {
            String screenshotFilePath = this.stepExecutionScreenshot(stepExecutionInfo, "after", logMessage.getUuid());
            logMessage.setScreenshotAfter(screenshotFilePath);
        }
    }

    private void onStepExecutionFailure(StepExecutionInfo stepExecutionInfo) {
        this.log(stepExecutionInfo, ConsoleColors.red("failure"));
        StepInformationLogMessage logMessage = this.stepIdLogMap.get(stepExecutionInfo.getId());
        logMessage.setError(stepExecutionInfo.getError());
        if (SeleniumDriverConfigHelper.shouldTakeScreenshotsAfterStep() || SeleniumDriverConfigHelper.shouldTakeScreenshotsAfterStepFailure()) {
            String screenshotFilePath = this.stepExecutionScreenshot(stepExecutionInfo, "after", logMessage.getUuid());
            logMessage.setScreenshotAfter(screenshotFilePath);
        }
    }

    private String stepExecutionScreenshot(StepExecutionInfo stepExecutionInfo, String status, UUID uuid) {
        WebDriver driver = QtafFactory.getWebDriver();
        if (DriverFactory.driverHasQuit()) {
            return null;
        }
        TestSuiteLogCollection suiteLogCollection = TestSuiteLogCollection.getInstance();
        File srcFile = this.takeScreenshot(driver);
        String path = this.getStepScreenshotDestinationPath(stepExecutionInfo, status, suiteLogCollection.getLogDirectory(), uuid);
        File destFile = this.saveStepScreenshot(srcFile, path);
        return destFile.getAbsolutePath();
    }

    private File takeScreenshot(WebDriver driver) {
        TakesScreenshot scrShot = (TakesScreenshot)driver;
        return (File)scrShot.getScreenshotAs(OutputType.FILE);
    }

    private String getStepScreenshotDestinationPath(StepExecutionInfo stepExecutionInfo, String status, String logDir, UUID uuid) {
        String name = stepExecutionInfo.getMethodInvocation().getMethod().getName();
        return logDir + "/" + name + "_" + status + "_" + uuid + ".png";
    }

    private File saveStepScreenshot(File srcFile, String path) {
        File destFile = new File(DirectoryHelper.preparePath((String)path));
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            QtafEvents.screenshotTaken.onNext((Object)destFile);
        }
        catch (IOException e) {
            QtafFactory.getLogger().error(e, new Object[0]);
        }
        return destFile;
    }

    private void log(StepExecutionInfo stepExecutionInfo, String message) {
        String assertionMessage = "[Step] [%s] [%s] %s: %s";
        String stepMessage = "[Step] [%s] [%s] %s";
        this.logger.info(stepMessage.formatted(stepExecutionInfo.getId(), stepExecutionInfo.getAnnotation().name(), message), new Object[0]);
        if (stepExecutionInfo.getLogMessage() != null) {
            for (AssertionLogMessage m : stepExecutionInfo.getLogMessage().getAssertions()) {
                if (m.hasFailed()) {
                    this.logger.info(assertionMessage.formatted(new Object[]{stepExecutionInfo.getId(), m.type(), ConsoleColors.red("failed"), m.getMessage()}), new Object[0]);
                    continue;
                }
                this.logger.info(assertionMessage.formatted(new Object[]{stepExecutionInfo.getId(), m.type(), ConsoleColors.green("passed"), m.getMessage()}), new Object[0]);
            }
        }
    }
}

