/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.config;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Provides;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.io.FileHelper;
import de.qytera.qtaf.core.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ConfigurationFactory {
    public static final String FILE_PATH = "qtaf.json";
    public static final String CONFIGURATION_RESOURCE_URL = "/qtaf.json";
    public static final String QTAF_CONFIG_RESOURCES_BASE_DIR = "$USER_DIR/src/test/resources";
    private static final Map<String, ConfigMap> configMaps = new HashMap<String, ConfigMap>();
    private static final Logger logger = QtafFactory.getLogger();

    private ConfigurationFactory() {
    }

    @Provides
    public static ConfigMap getInstance() {
        String config = System.getProperty("config");
        return ConfigurationFactory.getInstance(Objects.requireNonNullElse(config, FILE_PATH));
    }

    public static String readDefaultConfigurationFileContent() throws IOException {
        String line;
        InputStream inputStream = ConfigurationFactory.class.getResourceAsStream(CONFIGURATION_RESOURCE_URL);
        if (inputStream == null) {
            throw new IOException("Error: Default configuration resource not found");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static boolean createConfigurationFileIfNotExists() throws IOException {
        return ConfigurationFactory.createConfigurationFileIfNotExists(QTAF_CONFIG_RESOURCES_BASE_DIR, FILE_PATH);
    }

    public static boolean createConfigurationFileIfNotExists(String qtafConfigResourcesBaseDir, String filePath) throws IOException {
        return FileHelper.createFileIfNotExists((String)(qtafConfigResourcesBaseDir + "/" + filePath), (String)ConfigurationFactory.readDefaultConfigurationFileContent());
    }

    public static ConfigMap getInstance(String fileName) {
        if (configMaps.get(fileName) != null) {
            return configMaps.get(fileName);
        }
        Path location = Paths.get(DirectoryHelper.preparePath((String)"$USER_DIR/src/test/resources/") + fileName, new String[0]);
        String json = null;
        try {
            if (!ConfigurationFactory.createConfigurationFileIfNotExists()) {
                ConfigurationFactory.logFatal("Could not create configuration file");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ConfigurationFactory.logFatal("Could not create configuration file");
        }
        try {
            json = new String(Files.readAllBytes(location));
        }
        catch (IOException e) {
            try {
                json = ConfigurationFactory.readDefaultConfigurationFileContent();
            }
            catch (IOException ioException) {
                e.printStackTrace();
                ConfigurationFactory.logFatal("Configuration file not found: " + fileName);
            }
        }
        try {
            DocumentContext documentContext = JsonPath.parse((String)json);
            ConfigMap configMap = new ConfigMap(documentContext, location.toAbsolutePath().toString());
            configMaps.put(fileName, configMap);
            return configMaps.get(fileName);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            ConfigurationFactory.logFatal("Error: Syntax error in " + fileName);
            return null;
        }
    }

    private static void logFatal(String message) {
        logger.fatal("[ConfigurationFactory] " + message, new Object[0]);
        System.exit(1);
    }
}

