/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium;

import de.qytera.qtaf.core.selenium.AbstractDriver;
import io.appium.java_client.android.AndroidDriver;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class AbstractAndroidDriver
extends AbstractDriver {
    protected DesiredCapabilities getCapabilities() {
        DesiredCapabilities dc = new DesiredCapabilities();
        this.logDesiredCapability("deviceName", CONFIG.getString("appium.capabilities.deviceName"));
        this.logDesiredCapability("platformName", CONFIG.getString("appium.capabilities.platformName"));
        dc.setCapability("deviceName", CONFIG.getString("appium.capabilities.deviceName"));
        dc.setCapability("platformName", CONFIG.getString("appium.capabilities.platformName"));
        return dc;
    }

    protected void logDesiredCapability(String capability, String value) {
        AbstractAndroidDriver.logInfo(String.format("[DesiredCapabilities] %s: %s", capability, value));
    }

    protected DesiredCapabilities getDesiredCapabilitiesBrowser(String browserName) {
        DesiredCapabilities dc = this.getCapabilities();
        this.logDesiredCapability("browserName", browserName);
        dc.setCapability("browserName", browserName);
        return dc;
    }

    protected AndroidDriver getAndroidDriver(DesiredCapabilities dc) {
        try {
            AbstractAndroidDriver.logInfo("[Android Driver] URL: " + CONFIG.getString("appium.driverSettings.url"));
            return new AndroidDriver(new URL(CONFIG.getString("appium.driverSettings.url")), (Capabilities)dc);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

