/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.collection;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.annotations.TestFeature;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.index.FeatureLogCollectionIndex;
import de.qytera.qtaf.core.log.model.index.ScenarioLogCollectionIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestFeatureLogCollection {
    private static final FeatureLogCollectionIndex index = FeatureLogCollectionIndex.getInstance();
    private final String featureId;
    private String featureName = "";
    private String featureDescription = "";
    private TestFeature testFeatureAnnotation = null;
    private final List<TestScenarioLogCollection> testScenarioLogCollection = Collections.synchronizedList(new ArrayList());

    private TestFeatureLogCollection(String featureId, TestFeature testFeatureAnnotation) {
        this.featureId = featureId;
        this.featureName = testFeatureAnnotation.name();
        this.featureDescription = testFeatureAnnotation.description();
        this.testFeatureAnnotation = testFeatureAnnotation;
        QtafFactory.getLogger().debug(String.format("[FeatureLogCollection] Created feature log: id=%s, hash=%s, name=%s, description=%S", featureId, this.hashCode(), this.featureName, this.featureDescription), new Object[0]);
    }

    private TestFeatureLogCollection(String featureId, String featureName) {
        this.featureId = featureId;
        this.featureName = featureName;
        QtafFactory.getLogger().debug(String.format("[FeatureLogCollection] Created feature log: id=%s, hash=%s, name=%s", featureId, this.hashCode(), featureName), new Object[0]);
    }

    public static synchronized TestFeatureLogCollection createFeatureLogCollectionIfNotExists(String featureId, String featureName) {
        QtafFactory.getLogger().debug(String.format("[FeatureLogCollection]  feature log index: size=%s, scenario log index: size=%s", index.size(), ScenarioLogCollectionIndex.getInstance().size()), new Object[0]);
        if (index.get(featureId) != null) {
            return index.get(featureId);
        }
        TestFeatureLogCollection collection = new TestFeatureLogCollection(featureId, featureName);
        return index.put(featureId, collection);
    }

    public static synchronized TestFeatureLogCollection createFeatureLogCollectionIfNotExists(String featureId, TestFeature testFeatureAnnotation) {
        if (index.get(featureId) != null) {
            return index.get(featureId);
        }
        TestFeatureLogCollection collection = new TestFeatureLogCollection(featureId, testFeatureAnnotation);
        return index.put(featureId, collection);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestFeatureLogCollection)) {
            return false;
        }
        TestFeatureLogCollection c = (TestFeatureLogCollection)o;
        return this.getFeatureId().equals(c.getFeatureId());
    }

    public int hashCode() {
        return this.getFeatureId().hashCode();
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureDescription() {
        return this.featureDescription;
    }

    public synchronized List<TestScenarioLogCollection> getScenarioLogCollection() {
        return this.testScenarioLogCollection;
    }

    public synchronized Map<String, List<TestScenarioLogCollection>> getScenariosGroupedByAbstractScenarioId() {
        return Collections.synchronizedMap(this.testScenarioLogCollection.stream().collect(Collectors.groupingBy(TestScenarioLogCollection::getAbstractScenarioId)));
    }

    public synchronized TestScenarioLogCollection createScenarioIfNotExists(String featureId, String abstractScenarioId, String instanceId, String scenarioName) {
        TestScenarioLogCollection testScenarioLog = TestScenarioLogCollection.createTestScenarioLogCollection(featureId, abstractScenarioId, instanceId, scenarioName);
        if (!this.testScenarioLogCollection.contains(testScenarioLog)) {
            this.testScenarioLogCollection.add(testScenarioLog);
        }
        return testScenarioLog;
    }

    public synchronized TestScenarioLogCollection addScenarioLogCollection(TestScenarioLogCollection collection) {
        if (!this.testScenarioLogCollection.contains(collection)) {
            this.testScenarioLogCollection.add(collection);
        }
        return collection;
    }

    public TestFeature getTestFeatureAnnotation() {
        return this.testFeatureAnnotation;
    }

    public TestFeatureLogCollection setTestFeatureAnnotation(TestFeature testFeatureAnnotation) {
        this.testFeatureAnnotation = testFeatureAnnotation;
        return this;
    }

    public int countScenarioLogs() {
        return this.testScenarioLogCollection.size();
    }

    public void clearCollection() {
        this.testScenarioLogCollection.clear();
    }

    public static boolean exists(String featureId) {
        return index.get(featureId) != null;
    }

    public static int getIndexSize() {
        return index.size();
    }

    public static void clearIndex() {
        index.clear();
    }
}

