/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.guice.method_interceptor;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.guice.invokation.BeforeSuiteExecutionInfo;
import de.qytera.qtaf.core.guice.method_interceptor.QtafTestNGAnnotatedMethodInterceptor;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;
import org.testng.annotations.BeforeSuite;

public class QtafTestNGBeforeSuiteInterceptor
extends QtafTestNGAnnotatedMethodInterceptor<BeforeSuiteExecutionInfo> {
    public QtafTestNGBeforeSuiteInterceptor() {
        super(QtafEvents.beforeTestSuite, QtafEvents.beforeTestSuiteSuccess, QtafEvents.beforeTestSuiteFailure);
    }

    @Override
    public void onInvoke(MethodInvocation methodInvocation) {
        QtafFactory.getLogger().debug(String.format("Intercept @BeforeSuite method: name=%s", methodInvocation.getMethod().getName()), new Object[0]);
    }

    @Override
    public Annotation getAnnotation(MethodInvocation methodInvocation) {
        return methodInvocation.getClass().getAnnotation(BeforeSuite.class);
    }

    @Override
    public BeforeSuiteExecutionInfo buildStepExecutionInfoEntity(MethodInvocation methodInvocation) {
        BeforeSuiteExecutionInfo stepExecutionInfoEntity = (BeforeSuiteExecutionInfo)new BeforeSuiteExecutionInfo().setAnnotation((BeforeSuite)this.getAnnotation(methodInvocation)).setMethodInvocation(methodInvocation);
        stepExecutionInfoEntity.setId(stepExecutionInfoEntity.hashCode());
        stepExecutionInfoEntity.setThread(Thread.currentThread());
        stepExecutionInfoEntity.setStackTraceElements(Thread.currentThread().getStackTrace());
        return stepExecutionInfoEntity;
    }

    @Override
    public String buildScenarioName(String featureName, String scenarioId) {
        return "Before Test Suite Execution";
    }

    @Override
    public String buildScenarioDescription(String featureName, String scenarioName) {
        return "Executed before feature test suite";
    }
}

