/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.context;

import com.google.inject.Injector;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.QtafInitializer;
import de.qytera.qtaf.core.config.annotations.TestFeature;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.context.TestContextHelper;
import de.qytera.qtaf.core.guice.QtafInjector;
import de.qytera.qtaf.core.guice.QtafModule;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.selenium.DriverFactory;
import de.qytera.qtaf.testng.context.AssertionContext;
import de.qytera.qtaf.testng.event_listener.TestNGEventListener;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.testng.annotations.Guice;
import org.testng.annotations.Listeners;

@Listeners(value={TestNGEventListener.class})
@Guice(modules={QtafModule.class})
public abstract class QtafTestNGContext
implements IQtafTestContext,
AssertionContext {
    public static ConfigMap config;
    public static WebDriver driver;
    protected static JavascriptExecutor js;
    public static final TestSuiteLogCollection testSuiteLogCollection;
    protected TestFeature testFeatureAnnotation;
    protected TestFeatureLogCollection testFeatureLogCollection = null;
    protected TestScenarioLogCollection logCollection;
    private boolean isInitialized = false;
    protected String NO_MESSAGE = "<no-message>";
    protected static final Injector injector;

    protected QtafTestNGContext() {
        this.initialize();
    }

    @Override
    public QtafTestNGContext initialize() {
        if (this.isInitialized) {
            return this;
        }
        QtafInitializer.initialize();
        config = QtafFactory.getConfiguration();
        driver = QtafFactory.getWebDriver();
        js = (JavascriptExecutor)driver;
        this.testFeatureAnnotation = this.getClass().getAnnotation(TestFeature.class);
        this.isInitialized = true;
        return this;
    }

    protected static <T> T load(IQtafTestContext context, Class<T> c) {
        Object pageObject = injector.getInstance(c);
        if (pageObject instanceof IQtafTestContext) {
            IQtafTestContext testContext = (IQtafTestContext)pageObject;
            testContext.setLogCollection(context.getLogCollection());
            testContext.initialize();
        }
        return (T)pageObject;
    }

    protected <T> T load(Class<T> c) {
        return QtafTestNGContext.load(this, c);
    }

    protected void initElements() {
        PageFactory.initElements((SearchContext)driver, (Object)this);
    }

    @Override
    public void restartDriver() {
        driver = DriverFactory.getDriver(true);
    }

    public void jsExec(String script) {
        js.executeScript(script, new Object[0]);
    }

    public void jsExec(String script, Object ... args) {
        js.executeScript(script, args);
    }

    @Override
    public TestScenarioLogCollection getLogCollection() {
        return this.logCollection;
    }

    @Override
    public QtafTestNGContext setLogCollection(TestScenarioLogCollection collection) {
        this.logCollection = collection;
        return this;
    }

    @Override
    public void addLoggerToFieldsRecursively() {
        TestContextHelper.addLoggerToFieldsRecursively(this);
    }

    static {
        driver = null;
        js = null;
        testSuiteLogCollection = QtafFactory.getTestSuiteLogCollection();
        injector = QtafInjector.getInstance();
    }
}

