/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.listener;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.payload.QtafTestStepEventPayload;
import de.qytera.qtaf.core.events.payload.ScenarioStatus;
import de.qytera.qtaf.core.reflection.FieldHelper;
import de.qytera.qtaf.cucumber.events.payload.CucumberScenarioEventPayload;
import de.qytera.qtaf.cucumber.helper.CucumberLogMessageHelper;
import de.qytera.qtaf.cucumber.helper.CucumberScenarioHelper;
import de.qytera.qtaf.cucumber.helper.CucumberTestCaseStateHelper;
import de.qytera.qtaf.cucumber.helper.CucumberTestStepHelper;
import de.qytera.qtaf.cucumber.log.model.message.CucumberStepLogMessage;
import de.qytera.qtaf.cucumber.log.model.message.index.CucumberStepIndex;
import de.qytera.qtaf.testng.context.QtafTestNGContext;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java.Scenario;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStep;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class QtafCucumberHooks
extends QtafTestNGContext {
    private static CucumberStepIndex index = CucumberStepIndex.getInstance();

    public final void beforeScenario(Scenario scenario) {
        CucumberScenarioEventPayload eventPayload = new CucumberScenarioEventPayload(scenario);
        eventPayload.setScenarioStatus(ScenarioStatus.PENDING);
        QtafEvents.testStarted.onNext((Object)eventPayload);
        List<CucumberStepLogMessage> logMessages = null;
        try {
            logMessages = CucumberLogMessageHelper.createLogMessagesFromScenario(scenario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (logMessages != null);
        for (CucumberStepLogMessage logMessage : logMessages) {
            index.put(logMessage.getId(), logMessage);
        }
    }

    public final void beforeStep(Scenario scenario) {
        TestCaseState state = CucumberScenarioHelper.getTestCaseState(scenario);
        TestCase testCase = CucumberTestCaseStateHelper.getTestCase(state);
        assert (testCase != null);
        UUID stepId = (UUID)FieldHelper.getFieldValue((Object)state, "currentTestStepId");
        TestStep testStep = CucumberTestStepHelper.findByTestStepIdInAttribute(testCase.getTestSteps(), stepId, "beforeStepHookSteps");
        assert (testStep != null);
        CucumberStepLogMessage logMessage = (CucumberStepLogMessage)index.get(testStep.getId());
        logMessage.setStart(new Date());
    }

    public final void afterStep(Scenario scenario) {
        TestCaseState state = CucumberScenarioHelper.getTestCaseState(scenario);
        TestCase testCase = CucumberTestCaseStateHelper.getTestCase(state);
        assert (testCase != null);
        UUID stepId = (UUID)FieldHelper.getFieldValue((Object)state, "currentTestStepId");
        TestStep testStep = CucumberTestStepHelper.findByTestStepIdInAttribute(testCase.getTestSteps(), stepId, "afterStepHookSteps");
        int testStepPosition = CucumberTestStepHelper.getTestStepPosition(testCase.getTestSteps(), testStep);
        List<Result> testStepResults = CucumberTestCaseStateHelper.getStepResults(state);
        Result result = testStepResults.get(testStepPosition);
        assert (testStep != null);
        CucumberStepLogMessage logMessage = (CucumberStepLogMessage)index.get(testStep.getId());
        if (logMessage == null) {
            return;
        }
        logMessage.setScenarioId(scenario.getId()).setEnd(new Date());
        CucumberLogMessageHelper.applyResultToLogMessage(logMessage, result);
    }

    public final void afterScenario(Scenario scenario) {
        CucumberScenarioEventPayload eventPayload = new CucumberScenarioEventPayload(scenario);
        if (eventPayload.getScenarioStatus() == ScenarioStatus.SUCCESS) {
            eventPayload.setScenarioEnd(new Date());
            QtafEvents.testSuccess.onNext((Object)eventPayload);
        } else if (eventPayload.getScenarioStatus() == ScenarioStatus.FAILURE) {
            eventPayload.setScenarioEnd(new Date());
            QtafEvents.testFailure.onNext((Object)eventPayload);
        }
        List<CucumberStepLogMessage> logMessages = CucumberLogMessageHelper.createLogMessagesFromScenario(scenario);
        this.dispatchLogMessageEvents(scenario, logMessages);
        QtafFactory.getTestSuiteLogCollection().setEnd(new Date());
    }

    protected void dispatchLogMessageEvents(Scenario scenario, List<CucumberStepLogMessage> logMessages) {
        for (CucumberStepLogMessage logMessage : logMessages) {
            QtafTestStepEventPayload stepEventPayload = new QtafTestStepEventPayload().setScenarioId(scenario.getId()).setLogMessage(logMessage);
            QtafEvents.stepLog.onNext((Object)stepEventPayload);
        }
    }
}

