/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.helper;

import de.qytera.qtaf.core.reflection.FieldHelper;
import de.qytera.qtaf.cucumber.helper.CucumberTagHelper;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java.Scenario;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class CucumberScenarioHelper {
    private CucumberScenarioHelper() {
    }

    public static TestCaseState getTestCaseState(Scenario scenario) {
        TestCaseState testCaseState = null;
        for (Field field : FieldHelper.getDeclaredFieldsRecursively(scenario.getClass())) {
            field.setAccessible(true);
            try {
                Object fieldObject = field.get(scenario);
                if (!(fieldObject instanceof TestCaseState)) continue;
                testCaseState = (TestCaseState)fieldObject;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return testCaseState;
    }

    public static Map<String, String> getTagMetaData(Scenario scenario) {
        List scenarioTags = (List)scenario.getSourceTagNames();
        return CucumberTagHelper.getKeyValuePairs(scenarioTags);
    }

    public static String getScenarioIdFromTag(Scenario scenario) {
        List scenarioTags = (List)scenario.getSourceTagNames();
        return CucumberTagHelper.getTestId(scenarioTags);
    }
}

