/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.service;

import com.google.gson.Gson;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import lombok.Generated;

public class LogFileWriter {
    private static final TestSuiteLogCollection logCollection = TestSuiteLogCollection.getInstance();

    public static String persistLogs(TestSuiteLogCollection collection) {
        Gson gson = GsonFactory.getInstance();
        try {
            String json = gson.toJson((Object)collection);
            String reportPath = DirectoryHelper.preparePath((String)(logCollection.getLogDirectory() + "/Report.json"));
            DirectoryHelper.createDirectoryIfNotExists((String)logCollection.getLogDirectory());
            Files.write(Paths.get(reportPath, new String[0]), json.getBytes(), new OpenOption[0]);
            return reportPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void persistErrorLogs(ErrorLogCollection collection) {
        Gson gson = GsonFactory.getInstance();
        String json = gson.toJson((Object)collection);
        String reportPath = DirectoryHelper.preparePath((String)(logCollection.getLogDirectory() + "/Error.json"));
        try {
            DirectoryHelper.createDirectoryIfNotExists((String)logCollection.getLogDirectory());
            Files.write(Paths.get(reportPath, new String[0]), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    private LogFileWriter() {
    }
}

