/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.index;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LogMessageIndex {
    private final Map<Integer, LogMessage> index = Collections.synchronizedMap(new HashMap());
    private static final LogMessageIndex instance = new LogMessageIndex();

    private LogMessageIndex() {
    }

    public static synchronized LogMessageIndex getInstance() {
        return instance;
    }

    public synchronized LogMessage get(int id) {
        return this.index.get(id);
    }

    public synchronized LogMessage put(int id, LogMessage obj) {
        QtafFactory.getLogger().debug(String.format("[LogMessageIndex] Added log message: message_id=%s, message_hash=%s", id, obj.hashCode()), new Object[0]);
        this.index.put(id, obj);
        return obj;
    }

    public synchronized int size() {
        return this.index.size();
    }

    public synchronized void clear() {
        this.index.clear();
    }

    public List<LogMessage> getByFeatureId(String featureId) {
        return this.index.values().stream().filter(m -> m.getFeatureId().equals(featureId)).collect(Collectors.toList());
    }

    public List<LogMessage> getByAbstractScenarioId(String abstractScenarioId) {
        return this.index.values().stream().filter(m -> m.getAbstractScenarioId().equals(abstractScenarioId)).collect(Collectors.toList());
    }

    public List<LogMessage> getByScenarioId(String scenarioId) {
        return this.index.values().stream().filter(m -> m.getScenarioId().equals(scenarioId)).collect(Collectors.toList());
    }

    public List<StepInformationLogMessage> getByScenarioIdAndPending(String scenarioId) {
        return this.index.values().stream().filter(StepInformationLogMessage.class::isInstance).map(StepInformationLogMessage.class::cast).filter(step -> step.getScenarioId().equals(scenarioId) && step.getStatus() == StepInformationLogMessage.Status.PENDING).toList();
    }

    public List<StepInformationLogMessage> getByScenarioIdAndPassed(String scenarioId) {
        return this.index.values().stream().filter(StepInformationLogMessage.class::isInstance).map(StepInformationLogMessage.class::cast).filter(step -> step.getScenarioId().equals(scenarioId) && step.getStatus() == StepInformationLogMessage.Status.PASS).toList();
    }

    public List<StepInformationLogMessage> getByScenarioIdAndFailed(String scenarioId) {
        return this.index.values().stream().filter(StepInformationLogMessage.class::isInstance).map(StepInformationLogMessage.class::cast).filter(step -> step.getScenarioId().equals(scenarioId) && step.getStatus() == StepInformationLogMessage.Status.ERROR).toList();
    }
}

