/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.error;

import java.util.Arrays;
import java.util.List;

public class ErrorLog {
    protected Throwable error;
    protected String type = "";
    protected String message;
    protected List<String> stack = null;

    public ErrorLog(String message) {
        this.setError(new Exception(message));
        this.stack = null;
        this.message = message;
    }

    public ErrorLog(Throwable e) {
        this.setError(e);
        this.message = e.getMessage();
        this.stack = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).toList();
    }

    public Throwable getError() {
        return this.error;
    }

    public ErrorLog setError(Throwable error) {
        this.error = error;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ErrorLog setMessage(String message) {
        this.message = message;
        return this;
    }

    public List<String> getStackTrace() {
        return this.stack;
    }

    public String getErrorMessage() {
        return this.getError().getMessage();
    }

    public String getType() {
        return this.type;
    }

    public ErrorLog setType(String type) {
        this.type = type;
        return this;
    }

    public List<String> getStack() {
        return this.stack;
    }
}

