/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.collection;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.events.payload.IQtafTestEventPayload;
import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.index.LogMessageIndex;
import de.qytera.qtaf.core.log.model.index.ScenarioLogCollectionIndex;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TestScenarioLogCollection {
    private static final ScenarioLogCollectionIndex index = ScenarioLogCollectionIndex.getInstance();
    private static final LogMessageIndex logMessageIndex = LogMessageIndex.getInstance();
    private final String featureId;
    private final String scenarioId;
    private final String scenarioName;
    private String abstractScenarioId;
    private String instanceId;
    private String description;
    private Date start = null;
    private Date end = null;
    private long duration = 0L;
    private long threadId = 0L;
    private String threadName = "";
    private String[] groups = null;
    private String[] groupDependencies = null;
    private String[] methodDependencies = null;
    private final List<TestParameter> testParameters = Collections.synchronizedList(new ArrayList());
    private Annotation[] annotations;
    private Status status = Status.PENDING;
    private final List<LogMessage> logMessages = Collections.synchronizedList(new ArrayList());
    private final List<String> screenshotPaths = Collections.synchronizedList(new ArrayList());
    private String screenshotBefore = "";
    private String screenshotAfter = "";
    private final Map<String, String> tags = Collections.synchronizedMap(new HashMap());

    private TestScenarioLogCollection(String featureId, String scenarioId, String scenarioName) {
        this.featureId = featureId;
        this.scenarioId = scenarioId;
        this.scenarioName = scenarioName;
        QtafFactory.getLogger().debug(String.format("Created scenario log: id=%s, hash=%s, featureId=%s, scenarioName=%s", scenarioId, this.hashCode(), featureId, scenarioName), new Object[0]);
        QtafFactory.getLogger().debug(String.format("feature log index: size=%s, scenario log index: size=%s", index.size(), ScenarioLogCollectionIndex.getInstance().size()), new Object[0]);
    }

    public static synchronized TestScenarioLogCollection createTestScenarioLogCollection(String featureId, String abstractScenarioId, String instanceId, String scenarioName) {
        String scenarioId = TestScenarioLogCollection.buildId(abstractScenarioId, instanceId);
        if (index.get(scenarioId) != null) {
            return index.get(scenarioId);
        }
        TestScenarioLogCollection collection = new TestScenarioLogCollection(featureId, scenarioId, scenarioName);
        collection.setAbstractScenarioId(abstractScenarioId);
        collection.setInstanceId(instanceId);
        return index.put(scenarioId, collection);
    }

    public static synchronized TestScenarioLogCollection fromQtafTestEventPayload(IQtafTestEventPayload iQtafTestEventPayload) {
        String scenarioId = TestScenarioLogCollection.buildId(iQtafTestEventPayload.getAbstractScenarioId(), iQtafTestEventPayload.getInstanceId());
        if (index.get(scenarioId) != null) {
            return index.get(scenarioId);
        }
        TestScenarioLogCollection collection = new TestScenarioLogCollection(iQtafTestEventPayload.getFeatureId(), scenarioId, iQtafTestEventPayload.getScenarioName());
        collection.setAbstractScenarioId(iQtafTestEventPayload.getAbstractScenarioId()).setInstanceId(iQtafTestEventPayload.getInstanceId()).setDescription(iQtafTestEventPayload.getScenarioDescription()).setStart(iQtafTestEventPayload.getScenarioStart()).setEnd(iQtafTestEventPayload.getScenarioEnd()).setThreadId(iQtafTestEventPayload.getThreadId()).setThreadName(iQtafTestEventPayload.getThreadName()).setGroups(iQtafTestEventPayload.getGroups()).setGroupDependencies(iQtafTestEventPayload.getGroupDependencies()).setMethodDependencies(iQtafTestEventPayload.getMethodDependencies());
        if (iQtafTestEventPayload.getMethodInfoEntity() != null) {
            collection.setAnnotations(iQtafTestEventPayload.getMethodInfoEntity().getAnnotations()).addParameters(iQtafTestEventPayload.getMethodInfoEntity().getMethodParamValues());
        }
        return index.put(scenarioId, collection);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestScenarioLogCollection)) {
            return false;
        }
        TestScenarioLogCollection c = (TestScenarioLogCollection)o;
        return this.getFeatureId().equals(c.getFeatureId()) && this.getAbstractScenarioId().equals(c.getAbstractScenarioId()) && this.getInstanceId().equals(c.getInstanceId());
    }

    public int hashCode() {
        return (this.getFeatureId() + this.getAbstractScenarioId() + this.getInstanceId()).hashCode();
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public static String buildId(String abstractScenarioId, String instanceId) {
        return abstractScenarioId + "-" + instanceId;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getAbstractScenarioId() {
        return Objects.requireNonNullElse(this.abstractScenarioId, "");
    }

    public TestScenarioLogCollection setAbstractScenarioId(String abstractScenarioId) {
        this.abstractScenarioId = abstractScenarioId;
        return this;
    }

    public String getInstanceId() {
        return Objects.requireNonNullElse(this.instanceId, "");
    }

    public TestScenarioLogCollection setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public void computeStatus() {
        this.status = !LogMessageIndex.getInstance().getByScenarioIdAndFailed(this.getScenarioId()).isEmpty() ? Status.FAILURE : Status.SUCCESS;
    }

    public TestScenarioLogCollection setStatus(Status status) {
        this.status = status;
        return this;
    }

    public TestScenarioLogCollection setDescription(String description) {
        this.description = description;
        return this;
    }

    public TestScenarioLogCollection setGroupDependencies(String[] groupDependencies) {
        this.groupDependencies = groupDependencies;
        return this;
    }

    public void setMethodDependencies(String[] methodDependencies) {
        this.methodDependencies = methodDependencies;
    }

    public List<TestParameter> getTestParameters() {
        return this.testParameters;
    }

    public TestScenarioLogCollection addParameters(Parameter[] parameters, Object[] values) {
        for (int i = 0; i < parameters.length; ++i) {
            TestParameter testParameter = new TestParameter(parameters[i].getName(), values[i].getClass().getName(), values[i]);
            this.testParameters.add(testParameter);
        }
        return this;
    }

    public void addParameters(Object[] parameterValues) {
        for (int i = 0; i < parameterValues.length; ++i) {
            TestParameter testParameter = new TestParameter("arg" + i, parameterValues[i].getClass().getName(), parameterValues[i]);
            this.testParameters.add(testParameter);
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public <T> T getAnnotation(Class<T> annotationClass) {
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                if (!annotationClass.isInstance(annotation)) continue;
                return annotationClass.cast(annotation);
            }
        }
        return null;
    }

    public TestScenarioLogCollection setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
        return this;
    }

    public synchronized List<LogMessage> getLogMessages() {
        if (this.logMessages.isEmpty()) {
            return LogMessageIndex.getInstance().getByScenarioId(this.getScenarioId());
        }
        return this.logMessages;
    }

    public synchronized <T extends LogMessage> List<T> getLogMessages(Class<T> logMessageClass) {
        return this.getLogMessages().stream().filter(logMessageClass::isInstance).map(logMessageClass::cast).toList();
    }

    public synchronized StepInformationLogMessage getStepLogOfPendingStep() {
        List<StepInformationLogMessage> stepLogMessages = LogMessageIndex.getInstance().getByScenarioIdAndPending(this.getScenarioId());
        return stepLogMessages.isEmpty() ? null : stepLogMessages.get(0);
    }

    public synchronized void addLogMessage(LogMessage logMessage) {
        if (!this.logMessages.contains(logMessage)) {
            logMessage.setFeatureId(this.getFeatureId()).setAbstractScenarioId(this.getAbstractScenarioId()).setScenarioId(this.getScenarioId());
            logMessageIndex.put(logMessage.hashCode(), logMessage);
            this.logMessages.add(logMessage);
            QtafFactory.getLogger().debug(String.format("Added log message: message=%s, scenario_hash=%s", logMessage.getMessage(), this.hashCode()), new Object[0]);
            QtafFactory.getLogger().debug(String.format("Scenario %s: log_messages_size=%s, scenario_hash=%s, log_messages_list_hash=%s", this.getScenarioId(), this.logMessages.size(), this.hashCode(), this.logMessages.hashCode()), new Object[0]);
        }
    }

    public synchronized void addLogMessage(LogLevel level, String message) {
        LogMessage logMessage = new LogMessage(level, message);
        this.logMessages.add(logMessage);
    }

    public List<String> getScreenshotPaths() {
        return this.screenshotPaths;
    }

    public void addScreenshotPath(String filepath) {
        this.screenshotPaths.add(filepath);
    }

    public String getScreenshotBefore() {
        return this.screenshotBefore;
    }

    public void setScreenshotBefore(String screenshotBefore) {
        this.screenshotBefore = screenshotBefore;
    }

    public String getScreenshotAfter() {
        return this.screenshotAfter;
    }

    public void setScreenshotAfter(String screenshotAfter) {
        this.screenshotAfter = screenshotAfter;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public TestScenarioLogCollection addTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public TestScenarioLogCollection debug(String message) {
        this.addLogMessage(LogLevel.DEBUG, message);
        return this;
    }

    public TestScenarioLogCollection info(String message) {
        this.addLogMessage(LogLevel.INFO, message);
        return this;
    }

    public TestScenarioLogCollection warn(String message) {
        this.addLogMessage(LogLevel.WARN, message);
        return this;
    }

    public TestScenarioLogCollection error(String message) {
        this.addLogMessage(LogLevel.ERROR, message);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getGroupDependencies() {
        return this.groupDependencies;
    }

    public String[] getMethodDependencies() {
        return this.methodDependencies;
    }

    public Date getStart() {
        return this.start;
    }

    public TestScenarioLogCollection setStart(Date start) {
        this.start = start;
        return this;
    }

    public Date getEnd() {
        return this.end;
    }

    public TestScenarioLogCollection setEnd(Date end) {
        this.end = end;
        this.computeStatus();
        return this;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public TestScenarioLogCollection setThreadId(long threadId) {
        this.threadId = threadId;
        return this;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public TestScenarioLogCollection setThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public TestScenarioLogCollection setGroups(String[] groups) {
        this.groups = groups;
        return this;
    }

    public long getDuration() {
        if (this.end != null && this.start != null) {
            return this.end.getTime() - this.getStart().getTime();
        }
        return 0L;
    }

    public TestScenarioLogCollection setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public static boolean exists(TestScenarioLogCollection scenarioLogCollection) {
        return index.get(scenarioLogCollection.getFeatureId()) != null;
    }

    public static int getIndexSize() {
        return index.size();
    }

    public static void clearIndex() {
        index.clear();
    }

    public static enum Status {
        PENDING,
        SUCCESS,
        FAILURE,
        SKIPPED;

    }

    public static class TestParameter {
        private String name;
        private String type;
        private Object value;

        public TestParameter(String name, String type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public TestParameter setName(String name) {
            this.name = name;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public TestParameter setType(String type) {
            this.type = type;
            return this;
        }

        public Object getValue() {
            return this.value;
        }

        public TestParameter setValue(Object value) {
            this.value = value;
            return this;
        }
    }
}

