/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.guice.method_interceptor;

import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.guice.invokation.AbstractStepExecutionInfo;
import de.qytera.qtaf.core.guice.method_interceptor.AbstractTestNGAnnotatedMethodInterceptor;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import rx.subjects.PublishSubject;

public abstract class QtafTestNGAnnotatedMethodInterceptor<T extends AbstractStepExecutionInfo>
implements MethodInterceptor,
AbstractTestNGAnnotatedMethodInterceptor<T> {
    protected final PublishSubject<T> beforeStepExecution;
    protected final PublishSubject<T> afterStepExecutionSuccess;
    protected final PublishSubject<T> afterStepExecutionFailure;

    protected QtafTestNGAnnotatedMethodInterceptor(PublishSubject<T> beforeStepExecution, PublishSubject<T> afterStepExecutionSuccess, PublishSubject<T> afterStepExecutionFailure) {
        this.beforeStepExecution = beforeStepExecution;
        this.afterStepExecutionSuccess = afterStepExecutionSuccess;
        this.afterStepExecutionFailure = afterStepExecutionFailure;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object instance = methodInvocation.getThis();
        if (instance instanceof IQtafTestContext) {
            Object result;
            IQtafTestContext iqtafInstance = (IQtafTestContext)instance;
            this.onInvoke(methodInvocation);
            AbstractStepExecutionInfo stepExecution = this.buildStepExecutionInfoEntity(methodInvocation);
            this.beforeStepExecution.onNext((Object)stepExecution);
            TestFeatureLogCollection featureLogCollection = this.buildFeatureLogCollection(methodInvocation, iqtafInstance);
            TestScenarioLogCollection scenarioLogCollection = this.buildScenarioLogCollection(featureLogCollection, methodInvocation, iqtafInstance);
            this.updateTestContextWithLogCollection(iqtafInstance, scenarioLogCollection);
            try {
                result = this.executeStepMethod(methodInvocation, scenarioLogCollection);
                stepExecution.setResult(result);
                this.afterStepExecutionSuccess.onNext((Object)stepExecution);
            }
            catch (Throwable e) {
                this.handleStepExecutionFailure(scenarioLogCollection);
                stepExecution.setError(e);
                this.afterStepExecutionFailure.onNext((Object)stepExecution);
                throw e;
            }
            return result;
        }
        return methodInvocation.proceed();
    }

    protected abstract void onInvoke(MethodInvocation var1);
}

