/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.event_subscriber.test;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestEventPayload;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.log.model.error.SeleniumScreenshotError;
import de.qytera.qtaf.core.log.model.index.ScenarioLogCollectionIndex;
import de.qytera.qtaf.core.log.repository.ScenarioLogCollectionRepository;
import de.qytera.qtaf.core.selenium.helper.SeleniumDriverConfigHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class ScreenshotSubscriber
implements IEventSubscriber {
    @Override
    public void initialize() {
        if (SeleniumDriverConfigHelper.shouldTakeScreenshotsBeforeScenario()) {
            QtafEvents.testStarted.subscribe(this::takeScreenshotBefore, err -> QtafFactory.getLogger().error((Throwable)err, new Object[0]));
        }
        if (SeleniumDriverConfigHelper.shouldTakeScreenshotsAfterScenario()) {
            QtafEvents.testSuccess.subscribe(this::takeScreenshotAfter, err -> QtafFactory.getLogger().error((Throwable)err, new Object[0]));
            QtafEvents.testFailure.subscribe(this::takeScreenshotAfter, err -> QtafFactory.getLogger().error((Throwable)err, new Object[0]));
        }
    }

    private void takeTestScreenshot(IQtafTestEventPayload payload, String status) {
        WebDriver driver = QtafFactory.getWebDriver();
        TestSuiteLogCollection suiteLogCollection = TestSuiteLogCollection.getInstance();
        File srcFile = this.takeTestScreenshot(driver);
        String path = this.getScreenshotDestinationPath(payload.getScenarioId(), suiteLogCollection.getLogDirectory(), status);
        this.saveScreenshot(srcFile, path, payload.getScenarioId());
        TestScenarioLogCollection logCollection = ScenarioLogCollectionIndex.getInstance().get(payload.getScenarioId());
        if (status.equals("before")) {
            logCollection.setScreenshotBefore(path);
        } else {
            logCollection.setScreenshotAfter(path);
        }
    }

    private void takeScreenshotBefore(IQtafTestEventPayload payload) {
        this.takeTestScreenshot(payload, "before");
    }

    private void takeScreenshotAfter(IQtafTestEventPayload payload) {
        this.takeTestScreenshot(payload, "after");
    }

    private File takeTestScreenshot(WebDriver driver) {
        TakesScreenshot scrShot = (TakesScreenshot)driver;
        return (File)scrShot.getScreenshotAs(OutputType.FILE);
    }

    private String getScreenshotDestinationPath(String scenarioId, String logDir, String status) {
        return logDir + "/" + scenarioId + "_" + status + ".png";
    }

    private void saveScreenshot(File srcFile, String path, String scenarioId) {
        File destFile = new File(DirectoryHelper.preparePath((String)path));
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            TestScenarioLogCollection scenarioLog = ScenarioLogCollectionRepository.findById(scenarioId);
            scenarioLog.addScreenshotPath(destFile.getPath());
            QtafEvents.screenshotTaken.onNext((Object)destFile);
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private void handleError(Throwable e) {
        SeleniumScreenshotError error = new SeleniumScreenshotError(e);
        ErrorLogCollection errors = ErrorLogCollection.getInstance();
        errors.addErrorLog(error);
    }
}

