/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.event_subscriber.test;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestingContext;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.log.model.error.TestError;
import de.qytera.qtaf.core.log.model.index.LogMessageIndex;
import de.qytera.qtaf.core.log.service.LogFileWriter;

public class PersistLogFileSubscriber
implements IEventSubscriber {
    private final ErrorLogCollection errorLogCollection = ErrorLogCollection.getInstance();
    private final Logger logger = QtafFactory.getLogger();

    @Override
    public void initialize() {
        QtafEvents.frameworkInitialized.subscribe(v -> {}, this::handleFrameworkInitializationErrors);
        QtafEvents.afterDriverInitialization.subscribe(v -> {}, this::handleDriverInitializationErrors);
        QtafEvents.finishedTesting.subscribe(this::handleTestFinishedEvent, this::handleTestError);
    }

    private synchronized void handleTestFinishedEvent(IQtafTestingContext iTestContext) {
        TestSuiteLogCollection suiteLogCollection = QtafFactory.getTestSuiteLogCollection();
        this.logger.debug(String.format("[QTAF LogFileSubscriber] suite_hash=%s", suiteLogCollection.hashCode()), new Object[0]);
        this.logger.debug(String.format("[QTAF LogFileSubscriber] received event: features=%s", suiteLogCollection.getTestFeatureLogCollections().size()), new Object[0]);
        this.logger.debug(String.format("[QTAF LogFileSubscriber] log_message_index_size=%s", LogMessageIndex.getInstance().size()), new Object[0]);
        for (TestFeatureLogCollection featureLogCollection : suiteLogCollection.getTestFeatureLogCollections()) {
            this.logger.debug(String.format("[QTAF LogFileSubscriber] feature: id=%s, hash=%s, scenarios=%s", featureLogCollection.getFeatureId(), featureLogCollection.hashCode(), featureLogCollection.getScenarioLogCollection().size()), new Object[0]);
            for (TestScenarioLogCollection scenarioLogCollection : featureLogCollection.getScenarioLogCollection()) {
                this.logger.debug(String.format("[QTAF LogFileSubscriber] scenario: id=%s, hash=%s, steps=%s, step_list_hash=%s", scenarioLogCollection.getScenarioId(), scenarioLogCollection.hashCode(), scenarioLogCollection.getLogMessages().size(), scenarioLogCollection.getLogMessages().hashCode()), new Object[0]);
            }
        }
        QtafEvents.beforeLogsPersisted.onNext((Object)suiteLogCollection);
        String path = LogFileWriter.persistLogs(suiteLogCollection);
        this.logger.info("[QTAF] Log files persisted", new Object[0]);
        QtafEvents.logsPersisted.onNext((Object)path);
        QtafEvents.logsPersisted.onCompleted();
    }

    private void handleFrameworkInitializationErrors(Throwable e) {
        LogFileWriter.persistErrorLogs(this.errorLogCollection);
    }

    private void handleTestError(Throwable e) {
        TestError testError = new TestError(e);
        ErrorLogCollection errors = ErrorLogCollection.getInstance();
        errors.addErrorLog(testError);
    }

    private void handleDriverInitializationErrors(Throwable e) {
        LogFileWriter.persistErrorLogs(this.errorLogCollection);
    }
}

