/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.console.ConsoleColors;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestEventPayload;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.testng.helper.TestResultHelper;
import io.cucumber.testng.CucumberOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.testng.ITestResult;

public class TestNGLoggingSubscriber
implements IEventSubscriber {
    private static final TestSuiteLogCollection testSuiteLogCollection = QtafFactory.getTestSuiteLogCollection();
    private final Logger logger = QtafFactory.getLogger();
    private final List<Function<ITestResult, Optional<String>>> logMessageEnhancers = new ArrayList<Function<ITestResult, Optional<String>>>();

    @Override
    public void initialize() {
        QtafEvents.testStarted.subscribe(this::onTestStarted, this::logError);
        QtafEvents.testSuccess.subscribe(this::onTestSuccess, this::logError);
        QtafEvents.testFailure.subscribe(this::onTestFailure, this::logError);
        QtafEvents.testSkipped.subscribe(this::onTestSkipped, this::logError);
        QtafEvents.testFailedButWithinSuccessPercentage.subscribe(this::onTestFailedButWithinSuccessPercentage);
    }

    public void addLogMessageEnhancer(Function<ITestResult, Optional<String>> enhancer) {
        this.logMessageEnhancers.add(enhancer);
    }

    @Deprecated
    private void onTestStarted(IQtafTestEventPayload iQtafTestEventPayload) {
        Object object = iQtafTestEventPayload.getOriginalEvent();
        if (!(object instanceof ITestResult)) {
            return;
        }
        ITestResult iTestResult = (ITestResult)object;
        this.log(iTestResult, "started");
        IQtafTestContext testInstance = (IQtafTestContext)iTestResult.getInstance();
        Class clazz = iTestResult.getTestClass().getRealClass();
        CucumberOptions cucumberOptions = clazz.getAnnotation(CucumberOptions.class);
        if (cucumberOptions != null) {
            return;
        }
        TestFeatureLogCollection featureLogCollection = QtafFactory.getTestSuiteLogCollection().createFeatureIfNotExists(iQtafTestEventPayload.getFeatureId(), iQtafTestEventPayload.getFeatureName());
        TestScenarioLogCollection scenarioLogCollection = TestScenarioLogCollection.fromQtafTestEventPayload(iQtafTestEventPayload);
        testInstance.setLogCollection(scenarioLogCollection);
        featureLogCollection.addScenarioLogCollection(scenarioLogCollection);
        testInstance.addLoggerToFieldsRecursively();
    }

    private void onTestSuccess(IQtafTestEventPayload iQtafTestEventPayload) {
        if (!(iQtafTestEventPayload.getOriginalEvent() instanceof ITestResult)) {
            return;
        }
        ITestResult iTestResult = (ITestResult)iQtafTestEventPayload.getOriginalEvent();
        this.log(iTestResult, ConsoleColors.greenBright("success"));
        IQtafTestContext testInstance = (IQtafTestContext)iTestResult.getInstance();
        if (testInstance.getLogCollection() != null) {
            testInstance.getLogCollection().setStatus(TestScenarioLogCollection.Status.SUCCESS).setEnd(new Date(iTestResult.getEndMillis())).setDuration(iTestResult.getEndMillis() - iTestResult.getStartMillis());
        }
        testSuiteLogCollection.setEnd(new Date());
    }

    private void onTestFailure(IQtafTestEventPayload iQtafTestEventPayload) {
        if (!(iQtafTestEventPayload.getOriginalEvent() instanceof ITestResult)) {
            return;
        }
        ITestResult iTestResult = (ITestResult)iQtafTestEventPayload.getOriginalEvent();
        this.log(iTestResult, ConsoleColors.redBright("failure"));
        IQtafTestContext testInstance = (IQtafTestContext)iTestResult.getInstance();
        testInstance.getLogCollection().setStatus(TestScenarioLogCollection.Status.FAILURE).setEnd(new Date(iTestResult.getEndMillis())).setDuration(iTestResult.getEndMillis() - iTestResult.getStartMillis());
        testSuiteLogCollection.setEnd(new Date());
    }

    private void onTestFailedButWithinSuccessPercentage(IQtafTestEventPayload iQtafTestEventPayload) {
        if (!(iQtafTestEventPayload.getOriginalEvent() instanceof ITestResult)) {
            return;
        }
        ITestResult iTestResult = (ITestResult)iQtafTestEventPayload.getOriginalEvent();
        this.log(iTestResult, ConsoleColors.redBright("failure but within success percentage"));
        testSuiteLogCollection.setEnd(new Date());
    }

    private void onTestSkipped(IQtafTestEventPayload iQtafTestEventPayload) {
        if (!(iQtafTestEventPayload.getOriginalEvent() instanceof ITestResult)) {
            return;
        }
        ITestResult iTestResult = (ITestResult)iQtafTestEventPayload.getOriginalEvent();
        this.log(iTestResult, ConsoleColors.yellowBright("skipped"));
        IQtafTestContext testInstance = (IQtafTestContext)iTestResult.getInstance();
        testInstance.getLogCollection().setStatus(TestScenarioLogCollection.Status.SKIPPED).setEnd(new Date(iTestResult.getEndMillis())).setDuration(iTestResult.getEndMillis() - iTestResult.getStartMillis());
        testSuiteLogCollection.setEnd(new Date());
    }

    private void log(ITestResult iTestResult, String message) {
        String packageAndClassName = TestResultHelper.getTestContextInstance(iTestResult).getClass().getName();
        String methodName = iTestResult.getMethod().getMethodName();
        StringBuilder logMessage = new StringBuilder("[Test] ");
        for (Function<ITestResult, Optional<String>> enhancer : this.logMessageEnhancers) {
            Optional<String> result = enhancer.apply(iTestResult);
            result.ifPresent(s -> logMessage.append("[%s] ".formatted(s)));
        }
        logMessage.append("[%s.%s] %s".formatted(packageAndClassName, methodName, message));
        this.logger.info(logMessage.toString(), new Object[0]);
    }

    private void logError(Throwable e) {
        QtafFactory.getLogger().error(e, new Object[0]);
    }
}

