/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.event_listener;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.QtafInitializer;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.index.LogMessageIndex;
import de.qytera.qtaf.testng.events.payload.TestNGTestContextPayload;
import de.qytera.qtaf.testng.events.payload.TestNGTestEventPayload;
import de.qytera.qtaf.testng.helper.TestResultHelper;
import java.util.HashMap;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGEventListener
implements ITestListener {
    private static boolean testsStartedEventDispatched = false;
    private static boolean testsFinishedEventDispatched = false;
    private static final Map<Integer, ITestResult> testResultIdMap = new HashMap<Integer, ITestResult>();
    private static Logger logger = QtafFactory.getLogger();

    public void onStart(ITestContext iTestContext) {
        QtafInitializer.initialize();
        logger.info("[QTAF] - testing started", new Object[0]);
        if (!testsStartedEventDispatched) {
            QtafEvents.startTesting.onNext((Object)new TestNGTestContextPayload(iTestContext));
            QtafEvents.startTesting.onCompleted();
            testsStartedEventDispatched = true;
        }
    }

    public void onFinish(ITestContext iTestContext) {
        logger.info("[QTAF] - testing finished", new Object[0]);
        if (!testsFinishedEventDispatched) {
            QtafEvents.finishedTesting.onNext((Object)new TestNGTestContextPayload(iTestContext));
            QtafEvents.finishedTesting.onCompleted();
            testsFinishedEventDispatched = true;
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        if (testResultIdMap.get(iTestResult.hashCode()) == null) {
            try {
                TestNGTestEventPayload testEventPayload = new TestNGTestEventPayload(iTestResult);
                QtafEvents.testStarted.onNext((Object)testEventPayload);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            testResultIdMap.put(iTestResult.hashCode(), iTestResult);
        }
    }

    public void onTestSuccess(ITestResult iTestResult) {
        String scenarioId = TestResultHelper.getScenarioId(iTestResult);
        boolean hasScenarioPassed = LogMessageIndex.getInstance().getByScenarioIdAndFailed(scenarioId).isEmpty();
        try {
            if (hasScenarioPassed) {
                QtafEvents.testSuccess.onNext((Object)new TestNGTestEventPayload(iTestResult));
            } else {
                iTestResult.setStatus(2);
                QtafEvents.testFailure.onNext((Object)new TestNGTestEventPayload(iTestResult));
            }
        }
        catch (NoSuchMethodException e) {
            return;
        }
    }

    public void onTestFailure(ITestResult iTestResult) {
        try {
            QtafEvents.testFailure.onNext((Object)new TestNGTestEventPayload(iTestResult));
        }
        catch (NoSuchMethodException e) {
            return;
        }
    }

    public void onTestSkipped(ITestResult iTestResult) {
        try {
            QtafEvents.testSkipped.onNext((Object)new TestNGTestEventPayload(iTestResult));
        }
        catch (NoSuchMethodException e) {
            return;
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        try {
            QtafEvents.testFailedButWithinSuccessPercentage.onNext((Object)new TestNGTestEventPayload(iTestResult));
        }
        catch (NoSuchMethodException e) {
            return;
        }
    }
}

