/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.context;

import de.qytera.qtaf.core.config.helper.QtafTestExecutionConfigHelper;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.guice.annotations.Step;
import de.qytera.qtaf.core.guice.invokation.StepExecutionInfo;
import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.message.AssertionLogMessage;
import de.qytera.qtaf.core.log.model.message.AssertionLogMessageType;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Ignore;

public interface AssertionContext {
    @Ignore
    public TestScenarioLogCollection getLogCollection();

    @Ignore
    default public String getNoMessageString() {
        return "<no-message>";
    }

    @Ignore
    default public void assertTrue(boolean condition, String message) {
        this.assertTrue(condition, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertTrue(boolean condition, String message, boolean continueOnFailure) {
        try {
            Assert.assertTrue((boolean)condition, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertTrue(condition, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertTrue(true, message, null);
    }

    @Ignore
    default public void assertFalse(boolean condition, String message) {
        this.assertFalse(condition, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertFalse(boolean condition, String message, boolean continueOnFailure) {
        try {
            Assert.assertFalse((boolean)condition, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertFalse(condition, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertFalse(false, message, null);
    }

    @Ignore
    default public void assertNull(Object object) {
        this.assertNull(object, this.getNoMessageString());
    }

    @Ignore
    default public void assertNull(Object object, String message) {
        this.assertNull(object, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNull(Object object, String message, boolean continueOnFailure) {
        try {
            Assert.assertNull((Object)object, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNull(object, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNull(null, message, null);
    }

    @Ignore
    default public void assertNotNull(Object object) {
        this.assertNotNull(object, this.getNoMessageString());
    }

    @Ignore
    default public void assertNotNull(Object object, String message) {
        this.assertNotNull(object, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNotNull(Object object, String message, boolean continueOnFailure) {
        try {
            Assert.assertNotNull((Object)object, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNotNull(object, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNotNull(object, message, null);
    }

    @Ignore
    default public void assertSame(Object actual, Object expected) {
        this.assertSame(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertSame(Object actual, Object expected, String message) {
        this.assertSame(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertSame(Object object, Object expected, String message, boolean continueOnFailure) {
        try {
            Assert.assertSame((Object)object, (Object)expected, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertSame(object, expected, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertSame(object, expected, message, null);
    }

    @Ignore
    default public void assertNotSame(Object actual, Object expected) {
        this.assertNotSame(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertNotSame(Object actual, Object expected, String message) {
        this.assertNotSame(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNotSame(Object object, Object expected, String message, boolean continueOnFailure) {
        try {
            Assert.assertNotSame((Object)object, (Object)expected, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNotSame(object, expected, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNotSame(object, expected, message, null);
    }

    @Ignore
    default public void assertEquals(Object object1, Object object2) {
        this.assertEquals(object1, object2, this.getNoMessageString());
    }

    @Ignore
    default public void assertEquals(Object object1, Object object2, String message) {
        this.assertEquals(object1, object2, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertEquals(Object object1, Object object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertEquals((Object)object1, (Object)object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertEquals(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertEquals(object1, object2, message, null);
    }

    @Ignore
    default public void assertEqualsDeep(Set<?> actual, Set<?> expected) {
        this.assertEqualsDeep(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        this.assertEqualsDeep(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        this.assertEqualsDeep(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        this.assertEqualsDeep(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertEqualsDeep(Map<?, ?> object1, Map<?, ?> object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertEqualsDeep(object1, object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertEqualsDeep(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertEqualsDeep(object1, object2, message, null);
    }

    @Ignore
    default public void assertEqualsDeep(Set<?> object1, Set<?> object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertEqualsDeep(object1, object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertEqualsDeep(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertEqualsDeep(object1, object2, message, null);
    }

    @Ignore
    default public void assertNotEqualsDeep(Set<?> actual, Set<?> expected) {
        this.assertNotEqualsDeep(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertNotEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        this.assertNotEqualsDeep(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        this.assertNotEqualsDeep(actual, expected, this.getNoMessageString());
    }

    @Ignore
    default public void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        this.assertNotEqualsDeep(actual, expected, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNotEqualsDeep(Map<?, ?> object1, Map<?, ?> object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertNotEqualsDeep(object1, object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNotEqualsDeep(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNotEqualsDeep(object1, object2, message, null);
    }

    @Ignore
    default public void assertNotEqualsDeep(Set<?> object1, Set<?> object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertNotEqualsDeep(object1, object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNotEqualsDeep(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNotEqualsDeep(object1, object2, message, null);
    }

    @Ignore
    default public void assertEqualsNoOrder(Object[] object1, Object[] object2) {
        this.assertEqualsNoOrder(object1, object2, this.getNoMessageString());
    }

    @Ignore
    default public void assertEqualsNoOrder(Object[] object1, Object[] object2, String message) {
        this.assertEqualsNoOrder(object1, object2, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertEqualsNoOrder(Object[] object1, Object[] object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertEqualsNoOrder((Object[])object1, (Object[])object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertEqualsNoOrder(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertEqualsNoOrder(object1, object2, message, null);
    }

    @Ignore
    default public void assertNotEquals(Object object1, Object object2) {
        this.assertNotEquals(object1, object2, this.getNoMessageString());
    }

    @Ignore
    default public void assertNotEquals(Object object1, Object object2, String message) {
        this.assertNotEquals(object1, object2, message, QtafTestExecutionConfigHelper.continueOnAssertionFailure());
    }

    @Ignore
    default public void assertNotEquals(Object object1, Object object2, String message, boolean continueOnFailure) {
        try {
            Assert.assertNotEquals((Object)object1, (Object)object2, (String)message);
        }
        catch (AssertionError error) {
            this.handleAssertNotEquals(object1, object2, message, error);
            if (!continueOnFailure) {
                throw error;
            }
            return;
        }
        this.handleAssertNotEquals(object1, object2, message, null);
    }

    @Ignore
    default public AssertionLogMessage buildAssertionLogMessage(StepInformationLogMessage stepLog, String message) {
        AssertionLogMessage assertionLogMessage = new AssertionLogMessage(LogLevel.INFO, message);
        assertionLogMessage.setStep(stepLog).setFeatureId(this.getLogCollection().getFeatureId()).setAbstractScenarioId(this.getLogCollection().getAbstractScenarioId()).setScenarioId(this.getLogCollection().getScenarioId());
        return assertionLogMessage;
    }

    @Ignore
    default public void handleAssertCondition(AssertionLogMessageType type, boolean condition, String message, AssertionError error) {
        StepInformationLogMessage stepLog = (StepInformationLogMessage)this.getLogCollection().getStepLogOfPendingStep();
        if (stepLog == null) {
            stepLog = this.createNewStepLogMessage(message, error);
        }
        AssertionLogMessage assertionLogMessage = this.buildAssertionLogMessage(stepLog, message);
        assertionLogMessage.setType(type).setCondition(condition).setError(error);
        if (error != null) {
            assertionLogMessage.setStatusToFailed();
        } else {
            assertionLogMessage.setStatusToPassed();
        }
    }

    @Ignore
    default public void handleAssertCondition(AssertionLogMessageType type, Object object, String message, AssertionError error) {
        this.handleAssertCondition(type, object, null, message, error);
    }

    @Ignore
    default public void handleAssertCondition(AssertionLogMessageType type, Object object, Object expected, String message, AssertionError error) {
        StepInformationLogMessage stepLog = (StepInformationLogMessage)this.getLogCollection().getStepLogOfPendingStep();
        if (stepLog == null) {
            stepLog = this.createNewStepLogMessage(message, error);
        }
        AssertionLogMessage assertionLogMessage = this.buildAssertionLogMessage(stepLog, message);
        assertionLogMessage.setType(type).setActual(object).setExpected(expected).setError(error);
        if (error != null) {
            assertionLogMessage.setStatusToFailed();
        } else {
            assertionLogMessage.setStatusToPassed();
        }
    }

    private StepInformationLogMessage createNewStepLogMessage(final String message, AssertionError error) {
        TestScenarioLogCollection scenarioLogCollection = this.getLogCollection();
        Step stepAnnotation = new Step(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Step.class;
            }

            @Override
            public String name() {
                return message;
            }

            @Override
            public String description() {
                return message;
            }
        };
        StepExecutionInfo stepExecutionInfo = new StepExecutionInfo();
        StepInformationLogMessage stepLog = new StepInformationLogMessage(scenarioLogCollection.getAbstractScenarioId(), message);
        stepExecutionInfo.setId(stepExecutionInfo.hashCode());
        stepExecutionInfo.setAnnotation(stepAnnotation);
        stepExecutionInfo.setLogMessage(stepLog);
        stepExecutionInfo.setThread(Thread.currentThread());
        stepExecutionInfo.setError((Throwable)((Object)error));
        stepLog.setFeatureId(scenarioLogCollection.getFeatureId());
        stepLog.setScenarioId(scenarioLogCollection.getScenarioId());
        stepLog.setStep(stepAnnotation);
        stepLog.setStepName(message);
        stepLog.setStepDescription(message);
        stepLog.setStatus(error != null ? LogMessage.Status.FAILED : LogMessage.Status.PASSED);
        scenarioLogCollection.addLogMessage(stepLog);
        if (error == null) {
            QtafEvents.stepExecutionSuccess.onNext((Object)stepExecutionInfo);
        } else {
            QtafEvents.stepExecutionFailure.onNext((Object)stepExecutionInfo);
        }
        return stepLog;
    }

    @Ignore
    default public void handleAssertTrue(boolean condition, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_TRUE, condition, message, error);
    }

    @Ignore
    default public void handleAssertFalse(boolean condition, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_FALSE, condition, message, error);
    }

    @Ignore
    default public void handleAssertNull(Object object, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_NULL, object, message, error);
    }

    @Ignore
    default public void handleAssertNotNull(Object object, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_NOT_NULL, object, message, error);
    }

    @Ignore
    default public void handleAssertSame(Object object, Object expected, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_SAME, object, expected, message, error);
    }

    @Ignore
    default public void handleAssertNotSame(Object object, Object expected, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_NOT_SAME, object, expected, message, error);
    }

    @Ignore
    default public void handleAssertEquals(Object object1, Object object2, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_EQUALS, object1, object2, message, error);
    }

    @Ignore
    default public void handleAssertNotEquals(Object object1, Object object2, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_NOT_EQUALS, object1, object2, message, error);
    }

    @Ignore
    default public void handleAssertEqualsDeep(Object object1, Object object2, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_EQUALS_DEEP, object1, object2, message, error);
    }

    @Ignore
    default public void handleAssertNotEqualsDeep(Object object1, Object object2, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_NOT_EQUALS_DEEP, object1, object2, message, error);
    }

    @Ignore
    default public void handleAssertEqualsNoOrder(Object[] object1, Object[] object2, String message, AssertionError error) {
        this.handleAssertCondition(AssertionLogMessageType.ASSERT_EQUALS_NO_ORDER, object1, object2, message, error);
    }
}

