/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.helper;

import de.qytera.qtaf.core.reflection.FieldHelper;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestStep;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class CucumberTestStepHelper {
    private CucumberTestStepHelper() {
    }

    public static List<PickleStepTestStep> getPickleStepTestSteps(List<TestStep> testSteps) {
        return testSteps.stream().filter(PickleStepTestStep.class::isInstance).map(ts -> (PickleStepTestStep)ts).toList();
    }

    public static List<Integer> getTestStepPositions(List<TestStep> testSteps) {
        return testSteps.stream().filter(PickleStepTestStep.class::isInstance).map(testSteps::indexOf).toList();
    }

    public static int getTestStepPosition(List<TestStep> testSteps, TestStep testStep) {
        Optional<Integer> pos = testSteps.stream().filter(ts -> ts.getId().equals(testStep.getId())).map(testSteps::indexOf).findFirst();
        return pos.orElse(-1);
    }

    public static TestStep findByTestStepIdInAttribute(List<TestStep> testSteps, UUID stepId, String attributeName) {
        List steps = testSteps.stream().filter(ts -> FieldHelper.getFieldValue(ts, attributeName) != null && ((List)Objects.requireNonNull(FieldHelper.getFieldValue(ts, attributeName))).stream().filter(Objects::nonNull).anyMatch(hook -> hook.getId().equals(stepId))).collect(Collectors.toList());
        if (steps.size() == 1) {
            return (TestStep)steps.get(0);
        }
        return null;
    }
}

