/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.helper;

import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.cucumber.helper.CucumberScenarioHelper;
import de.qytera.qtaf.cucumber.helper.CucumberTestCaseStateHelper;
import de.qytera.qtaf.cucumber.helper.CucumberTestStepHelper;
import de.qytera.qtaf.cucumber.log.model.message.CucumberStepLogMessage;
import de.qytera.qtaf.cucumber.log.model.message.index.CucumberStepIndex;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java.Scenario;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.Step;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import java.util.ArrayList;
import java.util.List;

public class CucumberLogMessageHelper {
    static CucumberStepIndex index = CucumberStepIndex.getInstance();

    private CucumberLogMessageHelper() {
    }

    public static List<CucumberStepLogMessage> createLogMessagesFromScenario(Scenario scenario) {
        ArrayList<CucumberStepLogMessage> stepLogMessages = new ArrayList<CucumberStepLogMessage>();
        TestCaseState testCaseState = CucumberScenarioHelper.getTestCaseState(scenario);
        TestCase testCase = CucumberTestCaseStateHelper.getTestCase(testCaseState);
        List<Result> testStepResults = CucumberTestCaseStateHelper.getStepResults(testCaseState);
        assert (testCase != null);
        List testSteps = testCase.getTestSteps();
        List<Integer> testStepPositions = CucumberTestStepHelper.getTestStepPositions(testSteps);
        for (Integer pos : testStepPositions) {
            PickleStepTestStep testStep = (PickleStepTestStep)testSteps.get(pos);
            assert (testStepResults != null);
            CucumberStepLogMessage logMessage = CucumberLogMessageHelper.createCucumberStepLogMessageFromTestStep(testStep);
            stepLogMessages.add(logMessage);
        }
        return stepLogMessages;
    }

    public static CucumberStepLogMessage createCucumberStepLogMessageFromTestStep(PickleStepTestStep testStep) {
        Step step = testStep.getStep();
        if (index.get(testStep.getId()) != null) {
            return (CucumberStepLogMessage)index.get(testStep.getId());
        }
        String stepKeyword = step.getKeyword();
        String stepText = step.getText();
        StepArgument stepArgument = step.getArgument();
        CucumberStepLogMessage message = new CucumberStepLogMessage(testStep.getId(), stepKeyword + stepText, stepText);
        if (stepArgument instanceof DataTableArgument) {
            message.addStepParameter("data-table", stepArgument);
        } else if (stepArgument instanceof DocStringArgument) {
            message.addStepParameter("doc-string", stepArgument);
        }
        return message;
    }

    public static void applyResultToLogMessage(CucumberStepLogMessage message, Result testResult) {
        message.setStatus(CucumberLogMessageHelper.mapCucumberStatusToLogStatus(testResult.getStatus()));
        if (testResult.getError() != null) {
            message.setError(testResult.getError());
        }
    }

    public static LogMessage.Status mapCucumberStatusToLogStatus(Status status) {
        switch (status) {
            case PASSED: {
                return LogMessage.Status.PASSED;
            }
            case FAILED: {
                return LogMessage.Status.FAILED;
            }
            case SKIPPED: {
                return LogMessage.Status.SKIPPED;
            }
            case UNDEFINED: {
                throw new IllegalStateException("Cucumber status is marked as 'undefined': It could be that your step description could not be found");
            }
            case PENDING: {
                return LogMessage.Status.PENDING;
            }
            case UNUSED: {
                throw new IllegalStateException("Cucumber status is marked as 'unused'");
            }
            case AMBIGUOUS: {
                throw new IllegalStateException("Cucumber status is marked as 'ambiguous'");
            }
        }
        return null;
    }
}

