/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.ConfigurationFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.selenium.helper.SeleniumDriverConfigHelper;
import java.util.Map;
import lombok.Generated;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class CapabilityFactory {
    private static final ConfigMap CONFIG = QtafFactory.getConfiguration();

    public static ChromeOptions getCapabilitiesChrome() {
        CapabilityFactory.useJdkHttpClient();
        return CapabilityFactory.getCapabilitiesChromeRemote();
    }

    public static ChromeOptions getCapabilitiesChromeRemote() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments((String[])SeleniumDriverConfigHelper.getDriverOptions().toArray(String[]::new));
        options = options.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        Map prefs = ConfigurationFactory.getInstance().getValue("driver.preferences", Map.class);
        if (prefs instanceof Map) {
            options.setExperimentalOption("prefs", (Object)prefs);
        }
        return options;
    }

    public static EdgeOptions getCapabilitiesEdge() {
        CapabilityFactory.useJdkHttpClient();
        return CapabilityFactory.getCapabilitiesEdgeRemote();
    }

    public static EdgeOptions getCapabilitiesEdgeRemote() {
        EdgeOptions options = new EdgeOptions();
        options.addArguments((String[])SeleniumDriverConfigHelper.getDriverOptions().toArray(String[]::new));
        options = options.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        Map prefs = ConfigurationFactory.getInstance().getValue("driver.preferences", Map.class);
        if (prefs instanceof Map) {
            options.setExperimentalOption("prefs", (Object)prefs);
        }
        return options;
    }

    public static FirefoxOptions getCapabilitiesFirefox() {
        CapabilityFactory.useJdkHttpClient();
        return CapabilityFactory.getCapabilitiesFirefoxRemote();
    }

    public static FirefoxOptions getCapabilitiesFirefoxRemote() {
        FirefoxOptions options = new FirefoxOptions();
        options.addArguments((String[])SeleniumDriverConfigHelper.getDriverOptions().toArray(String[]::new));
        options = options.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        Map<String, Object> preferences = SeleniumDriverConfigHelper.getDriverPreferences();
        if (!preferences.isEmpty()) {
            FirefoxProfile profile = new FirefoxProfile();
            preferences.forEach((arg_0, arg_1) -> ((FirefoxProfile)profile).setPreference(arg_0, arg_1));
            options.setProfile(profile);
        }
        return options;
    }

    public static InternetExplorerOptions getCapabilitiesInternetExplorer() {
        InternetExplorerOptions caps = new InternetExplorerOptions();
        caps.setCapability("ignoreZoomSetting", true);
        caps.addCommandSwitches((String[])SeleniumDriverConfigHelper.getDriverOptions().toArray(String[]::new));
        caps = caps.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        return caps;
    }

    public static Capabilities getCapabilitiesAndroid() {
        DesiredCapabilities dc = new DesiredCapabilities(Map.of("deviceName", CONFIG.getString("appium.capabilities.deviceName"), "udid", CONFIG.getString("appium.capabilities.udid"), "browserVersion", CONFIG.getString("appium.capabilities.androidVersion"), "platformName", CONFIG.getString("appium.capabilities.platformName"), "appPackage", CONFIG.getString("appium.capabilities.appPackage"), "appActivity", CONFIG.getString("appium.capabilities.appActivity")));
        dc = dc.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        return dc;
    }

    public static Capabilities getCapabilitiesSaucelabs() {
        MutableCapabilities capabilities = new MutableCapabilities(Map.of("browserName", CONFIG.get("sauce.browserName"), "browserVersion", SeleniumDriverConfigHelper.getDriverVersion(), "platformName", SeleniumDriverConfigHelper.getPlatformName(), "sauce:options", Map.of("username", CONFIG.getString("sauce.username"), "accesskey", CONFIG.getString("sauce.accessKey"))));
        capabilities = capabilities.merge(SeleniumDriverConfigHelper.getDriverCapabilities());
        return capabilities;
    }

    private static void useJdkHttpClient() {
        System.setProperty("webdriver.http.factory", "jdk-http-client");
    }

    @Generated
    private CapabilityFactory() {
    }
}

