/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.message;

import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.error.ThrowableWrapper;
import de.qytera.qtaf.core.log.model.message.AssertionLogMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class LogMessage {
    protected Status status = Status.PENDING;
    protected final UUID uuid = UUID.randomUUID();
    protected List<AssertionLogMessage> assertions = Collections.synchronizedList(new ArrayList());
    protected Date start = null;
    protected Date end = null;
    protected ThrowableWrapper error = null;
    protected LogLevel level;
    protected String message = "";
    protected String featureId = "";
    protected String abstractScenarioId = "";
    protected String scenarioId = "";

    public LogMessage(LogLevel level, String message) {
        this.level = level;
        this.message = message;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean hasFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean hasPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isPending() {
        return this.getStatus() == Status.PENDING;
    }

    public boolean isSkipped() {
        return this.getStatus() == Status.SKIPPED;
    }

    public ThrowableWrapper getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public LogMessage setError(Throwable error) {
        this.error = new ThrowableWrapper(error);
        this.status = Status.FAILED;
        return this;
    }

    public LogMessage setError(ThrowableWrapper error) {
        this.error = error;
        this.setStatus(Status.FAILED);
        return this;
    }

    public Date getStart() {
        return this.start;
    }

    public LogMessage setStart(Date start) {
        this.start = start;
        return this;
    }

    public Date getEnd() {
        return this.end;
    }

    public LogMessage setEnd(Date end) {
        this.end = end;
        this.computeStatus();
        return this;
    }

    public long getDuration() {
        if (this.end != null && this.getStart() != null) {
            return this.end.getTime() - this.getStart().getTime();
        }
        return 0L;
    }

    public List<AssertionLogMessage> getAssertions() {
        return this.assertions;
    }

    public LogMessage setAssertions(List<AssertionLogMessage> assertions) {
        this.assertions = assertions;
        return this;
    }

    public LogMessage addAssertion(AssertionLogMessage assertion) {
        this.assertions.add(assertion);
        if (assertion.hasFailed()) {
            this.setStatus(Status.FAILED);
        }
        return this;
    }

    public void computeStatus() {
        if (this.error != null) {
            this.setStatus(Status.FAILED);
            return;
        }
        for (AssertionLogMessage assertion : this.assertions) {
            if (!assertion.hasFailed()) continue;
            this.setStatus(Status.FAILED);
            return;
        }
        this.setStatus(Status.PASSED);
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public LogMessage setLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    public LogMessage setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public LogMessage setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public LogMessage setFeatureId(String featureId) {
        this.featureId = featureId;
        return this;
    }

    public String getAbstractScenarioId() {
        return this.abstractScenarioId;
    }

    public LogMessage setAbstractScenarioId(String abstractScenarioId) {
        this.abstractScenarioId = abstractScenarioId;
        return this;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public LogMessage setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
        return this;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        PENDING,
        SKIPPED,
        PASSED,
        FAILED;

    }
}

