/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.message;

import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.error.ThrowableWrapper;
import de.qytera.qtaf.core.log.model.message.AssertionLogMessageType;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;

public class AssertionLogMessage
extends LogMessage {
    protected AssertionLogMessageType type;
    protected transient StepInformationLogMessage step;
    protected boolean condition;
    protected Object actual;
    protected Object expected;

    public AssertionLogMessage(LogLevel level, String message) {
        super(level, message);
    }

    public AssertionLogMessageType type() {
        return this.type;
    }

    public AssertionLogMessage setType(AssertionLogMessageType type) {
        this.type = type;
        return this;
    }

    public StepInformationLogMessage step() {
        return this.step;
    }

    public AssertionLogMessage setStep(StepInformationLogMessage step) {
        this.step = step;
        if (step != null) {
            step.addAssertion(this);
        }
        return this;
    }

    public boolean condition() {
        return this.condition;
    }

    public AssertionLogMessage setCondition(boolean condition) {
        this.condition = condition;
        return this;
    }

    public Object actual() {
        return this.actual;
    }

    public AssertionLogMessage setActual(Object actual) {
        this.actual = actual;
        return this;
    }

    public Object expected() {
        return this.expected;
    }

    public AssertionLogMessage setExpected(Object expected) {
        this.expected = expected;
        return this;
    }

    public ThrowableWrapper error() {
        return this.error;
    }

    public AssertionLogMessage setError(AssertionError error) {
        this.error = error != null ? new ThrowableWrapper((Throwable)((Object)error)) : null;
        return this;
    }

    public boolean wasExecuted() {
        return this.getStatus() != LogMessage.Status.PENDING;
    }

    @Override
    public boolean hasPassed() {
        return this.getStatus() == LogMessage.Status.PASSED;
    }

    @Override
    public boolean hasFailed() {
        return this.getStatus() == LogMessage.Status.FAILED;
    }

    public AssertionLogMessage setStatusToPassed() {
        this.setStatus(LogMessage.Status.PASSED);
        return this;
    }

    public AssertionLogMessage setStatusToFailed() {
        this.setStatus(LogMessage.Status.FAILED);
        return this;
    }
}

