/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log;

import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class Logger {
    private final org.apache.logging.log4j.Logger logging;
    private static final ErrorLogCollection errorLogCollection = ErrorLogCollection.getInstance();
    private static final Map<String, Logger> instances = new HashMap<String, Logger>();

    private Logger(String name) {
        this.logging = LogManager.getLogger((String)name);
    }

    public static Logger getInstance() {
        return Logger.getInstance("de.qytera.qtaf.core");
    }

    public static Logger getInstance(String name) {
        instances.computeIfAbsent(name, Logger::new);
        return instances.get(name);
    }

    public void trace(String message, Object ... params) {
        this.logging.trace(message, params);
    }

    public void debug(String message, Object ... params) {
        this.logging.debug(message, params);
    }

    public void info(String message, Object ... params) {
        this.logging.info(message, params);
    }

    public void warn(String message, Object ... params) {
        this.logging.warn(message, params);
    }

    public void error(Throwable t, Object ... params) {
        this.logging.error(t.getMessage(), params);
        errorLogCollection.addErrorLog(t);
    }

    public void error(String message, Object ... params) {
        this.logging.error(message, params);
        errorLogCollection.addErrorLog(message);
    }

    public void fatal(Throwable t, Object ... params) {
        this.logging.fatal(t.getMessage(), params);
        errorLogCollection.addErrorLog(t);
    }

    public void fatal(String message, Object ... params) {
        this.logging.fatal(message, params);
        errorLogCollection.addErrorLog(message);
    }
}

