/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.guice.method_interceptor;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.guice.annotations.Step;
import de.qytera.qtaf.core.guice.invokation.StepExecutionInfo;
import java.util.Date;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class QtafStepMethodInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (methodInvocation.getThis() instanceof IQtafTestContext && !methodInvocation.getMethod().getReturnType().getName().contains("io.restassured")) {
            Object result;
            QtafFactory.getLogger().debug(String.format("Intercept @Step method: name=%s", methodInvocation.getMethod().getName()), new Object[0]);
            Step step = methodInvocation.getMethod().getAnnotation(Step.class);
            StepExecutionInfo stepExecutionInfo = new StepExecutionInfo().setAnnotation(step).setMethodInvocation(methodInvocation);
            stepExecutionInfo.setId(stepExecutionInfo.hashCode());
            stepExecutionInfo.setThread(Thread.currentThread());
            stepExecutionInfo.setStackTraceElements(Thread.currentThread().getStackTrace());
            QtafEvents.beforeStepExecution.onNext((Object)stepExecutionInfo);
            try {
                result = methodInvocation.proceed();
                stepExecutionInfo.setResult(result);
                stepExecutionInfo.getLogMessage().setEnd(new Date());
                if (stepExecutionInfo.getLogMessage().hasPassed()) {
                    QtafEvents.stepExecutionSuccess.onNext((Object)stepExecutionInfo);
                } else {
                    QtafEvents.stepExecutionFailure.onNext((Object)stepExecutionInfo);
                }
            }
            catch (Throwable e) {
                stepExecutionInfo.setError(e);
                QtafEvents.stepExecutionFailure.onNext((Object)stepExecutionInfo);
                throw e;
            }
            return result;
        }
        return methodInvocation.proceed();
    }
}

