/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.gson.serializer.IQtafJsonSerializer;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.reflection.ClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.InvalidArgumentException;

public class GsonFactory {
    private static Gson instance = null;
    private static Gson instanceWithoutCustomSerializers = null;
    private static final Map<String, IQtafJsonSerializer> serializers = new HashMap<String, IQtafJsonSerializer>();
    private static final List<ExclusionStrategy> exclusionStrategies = new ArrayList<ExclusionStrategy>();

    private GsonFactory() {
    }

    public static Gson getInstanceWithoutCustomSerializers() {
        if (instanceWithoutCustomSerializers == null) {
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            instanceWithoutCustomSerializers = gsonBuilder.create();
        }
        return instanceWithoutCustomSerializers;
    }

    public static Gson getInstance() {
        if (instance == null) {
            GsonFactory.loadSerializers();
            GsonFactory.loadExclusionStrategies();
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            for (Map.Entry<String, IQtafJsonSerializer> entry : serializers.entrySet()) {
                gsonBuilder.registerTypeAdapter(entry.getValue().getSerializedObjectClass(), (Object)entry.getValue());
            }
            gsonBuilder.setExclusionStrategies(exclusionStrategies.toArray(new ExclusionStrategy[0]));
            instance = gsonBuilder.create();
        }
        return instance;
    }

    public static void loadSerializers() {
        try {
            Object[] lst;
            for (Object o : lst = ClassLoader.getInstancesOfDirectSubtypesOf(IQtafJsonSerializer.class)) {
                IQtafJsonSerializer s = (IQtafJsonSerializer)o;
                if (s.getSerializedObjectClass() == null) {
                    throw new InvalidArgumentException(s.getClass().getName() + " should declare a type for which it is responsible");
                }
                serializers.put(s.getClass().getName(), s);
            }
        }
        catch (Exception e) {
            QtafFactory.getLogger().error("GSON Initialization Error", new Object[0]);
            QtafFactory.getLogger().error(e.getMessage(), new Object[0]);
            ErrorLogCollection.getInstance().addErrorLog(e);
        }
    }

    public static void loadExclusionStrategies() {
        try {
            Object[] lst;
            for (Object o : lst = ClassLoader.getInstancesOfDirectSubtypesOf(ExclusionStrategy.class)) {
                ExclusionStrategy s = (ExclusionStrategy)o;
                exclusionStrategies.add(s);
            }
        }
        catch (Exception e) {
            QtafFactory.getLogger().error("GSON Initialization Error", new Object[0]);
            QtafFactory.getLogger().error(e.getMessage(), new Object[0]);
            ErrorLogCollection.getInstance().addErrorLog(e);
        }
    }
}

