/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.config.helper;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.util.TokenSeparatedStringHelper;
import java.util.List;

public class QtafTestExecutionConfigHelper {
    protected static final ConfigMap config = QtafFactory.getConfiguration();
    private static final String TEST_GROUPS = "tests.groups";
    private static final String TEST_ASSERTION_BEHAVIOUR_ON_FAILURE = "tests.continueOnAssertionFailure";
    public static final String LOGGING_LOG_STEPS = "logging.logSteps";

    private QtafTestExecutionConfigHelper() {
    }

    public static List<String> getTestGroupsFromConfiguration() {
        String configGroupString = config.getString(TEST_GROUPS);
        if (configGroupString == null) {
            return null;
        }
        return TokenSeparatedStringHelper.toList(configGroupString, ",", true);
    }

    public static boolean continueOnAssertionFailure() {
        return config.getBoolean(TEST_ASSERTION_BEHAVIOUR_ON_FAILURE);
    }

    public static boolean isStepLoggingEnabled() {
        ConfigMap config = QtafFactory.getConfiguration();
        return config.getBoolean(LOGGING_LOG_STEPS, false);
    }
}

