/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.helper;

import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberTagHelper {
    private static final String KEY_VALUE_REGEX = "^@([A-Za-z0-9-_]+):(.*)$";
    private static final String TAG_REGEX = "^@([A-Za-z0-9-_]+)";
    private static final String TEST_ID_REGEX = "^@TestName:(.*)$";

    private CucumberTagHelper() {
    }

    public static boolean isKeyValuePair(String s) {
        return s.matches(KEY_VALUE_REGEX);
    }

    public static boolean isTag(String s) {
        return s.matches(TAG_REGEX);
    }

    public static Matcher getKeyAndValueMatch(String s) {
        return Pattern.compile(KEY_VALUE_REGEX).matcher(s);
    }

    public static Map<String, String> getKeyValuePairsFromTagList(List<Tag> tags) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Tag tag : tags) {
            if (CucumberTagHelper.isKeyValuePair(tag.getName())) {
                Matcher m = CucumberTagHelper.getKeyAndValueMatch(tag.getName());
                if (!m.find()) continue;
                map.put(m.group(1), m.group(2));
                continue;
            }
            if (!CucumberTagHelper.isTag(tag.getName())) continue;
            map.put(tag.getName().replace("@", ""), "");
        }
        return map;
    }

    public static Map<String, String> getKeyValuePairs(List<String> tags) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String tag : tags) {
            if (CucumberTagHelper.isKeyValuePair(tag)) {
                Matcher m = CucumberTagHelper.getKeyAndValueMatch(tag);
                if (!m.find()) continue;
                map.put(m.group(1), m.group(2));
                continue;
            }
            if (!CucumberTagHelper.isTag(tag)) continue;
            map.put(tag.replace("@", ""), "");
        }
        return map;
    }

    public static Map<String, List<String>> getKeyValueListPairs(List<String> tags) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String tag : tags) {
            Matcher m;
            if (!CucumberTagHelper.isKeyValuePair(tag) || !(m = CucumberTagHelper.getKeyAndValueMatch(tag)).find()) continue;
            map.computeIfAbsent(m.group(1), k -> new ArrayList());
            ((List)map.get(m.group(1))).add(m.group(2));
        }
        return map;
    }

    public static String getTestId(List<String> tags) {
        for (String tag : tags) {
            Matcher m;
            if (!tag.matches(TEST_ID_REGEX) || !(m = Pattern.compile(TEST_ID_REGEX).matcher(tag)).find()) continue;
            return m.group(1);
        }
        return null;
    }
}

