/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;

public class SeleniumDriverConfigHelper {
    public static final String DRIVER_IMPLICIT_WAIT_TIMEOUT = "driver.implicitWaitTimeout";
    public static final String DRIVER_REMOTE_URL = "driver.remoteUrl";
    public static final String DRIVER_PLATFORM = "driver.platform";
    public static final String DRIVER_VERSION = "driver.version";
    public static final String DRIVER_OPTIONS = "driver.options";
    public static final String DRIVER_CAPABILITIES = "driver.capabilities";
    public static final String DRIVER_QUIT_AFTER_TESTING = "driver.quitAfterTesting";
    public static final String SCREENSHOTS_BEFORE_SCENARIO = "driver.screenshots.beforeScenario";
    public static final String SCREENSHOTS_AFTER_SCENARIO = "driver.screenshots.afterScenario";
    public static final String SCREENSHOTS_BEFORE_STEP = "driver.screenshots.beforeStep";
    public static final String SCREENSHOTS_AFTER_STEP = "driver.screenshots.afterStep";
    public static final String SCREENSHOTS_AFTER_STEP_FAILURE = "driver.screenshots.afterStepFailure";
    private static ConfigMap config = QtafFactory.getConfiguration();

    public static int getImplicitTimeout() {
        return config.getInt(DRIVER_IMPLICIT_WAIT_TIMEOUT, 30);
    }

    public static URL getRemoteUrl() {
        String url = config.getString(DRIVER_REMOTE_URL);
        try {
            if (url == null) {
                throw new MalformedURLException("Failed to get remote driver URL, configuration key '%s' is null".formatted(DRIVER_REMOTE_URL));
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            QtafFactory.getLogger().fatal("The given remote driver url is malformed: %s".formatted(url), new Object[0]);
            throw new IllegalArgumentException(e);
        }
    }

    public static String getPlatformName() {
        return config.getString(DRIVER_PLATFORM);
    }

    public static String getDriverVersion() {
        return config.getString(DRIVER_VERSION);
    }

    public static List<String> getDriverOptions() {
        return config.getList(DRIVER_OPTIONS).stream().filter(JsonPrimitive.class::isInstance).map(JsonPrimitive.class::cast).filter(JsonPrimitive::isString).map(JsonPrimitive::getAsString).toList();
    }

    public static Capabilities getDriverCapabilities() {
        MutableCapabilities capabilities = new MutableCapabilities();
        SeleniumDriverConfigHelper.toPrimitive(config.getMap(DRIVER_CAPABILITIES)).forEach((arg_0, arg_1) -> ((MutableCapabilities)capabilities).setCapability(arg_0, arg_1));
        return ImmutableCapabilities.copyOf((Capabilities)capabilities);
    }

    private static Map<String, Object> toPrimitive(Map<String, JsonElement> map) {
        HashMap<String, Object> primitiveMap = new HashMap<String, Object>();
        map.forEach((key, element) -> {
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                primitiveMap.put((String)key, SeleniumDriverConfigHelper.toPrimitive(primitive));
            } else if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                primitiveMap.put((String)key, SeleniumDriverConfigHelper.toPrimitive(array.asList()));
            } else if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                primitiveMap.put((String)key, SeleniumDriverConfigHelper.toPrimitive(object.asMap()));
            }
        });
        return primitiveMap;
    }

    private static List<Object> toPrimitive(List<JsonElement> array) {
        ArrayList<Object> primitiveArray = new ArrayList<Object>();
        array.forEach(element -> {
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                primitiveArray.add(SeleniumDriverConfigHelper.toPrimitive(primitive));
            } else if (element instanceof JsonArray) {
                JsonArray nestedArray = (JsonArray)element;
                primitiveArray.add(SeleniumDriverConfigHelper.toPrimitive(nestedArray.asList()));
            } else if (element instanceof JsonObject) {
                JsonObject nestedObject = (JsonObject)element;
                primitiveArray.add(SeleniumDriverConfigHelper.toPrimitive(nestedObject.asMap()));
            }
        });
        return primitiveArray;
    }

    private static Object toPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            try {
                return Long.parseLong(element.getAsString());
            }
            catch (NumberFormatException exception) {
                return Double.parseDouble(element.getAsString());
            }
        }
        return element.getAsString();
    }

    public static boolean shouldQuitDriverAfterTesting() {
        return config.getBoolean(DRIVER_QUIT_AFTER_TESTING);
    }

    public static boolean shouldTakeScreenshotsBeforeScenario() {
        return config.getBoolean(SCREENSHOTS_BEFORE_SCENARIO);
    }

    public static boolean shouldTakeScreenshotsAfterScenario() {
        return config.getBoolean(SCREENSHOTS_AFTER_SCENARIO);
    }

    public static boolean shouldTakeScreenshotsBeforeStep() {
        return config.getBoolean(SCREENSHOTS_BEFORE_STEP);
    }

    public static boolean shouldTakeScreenshotsAfterStep() {
        return config.getBoolean(SCREENSHOTS_AFTER_STEP);
    }

    public static boolean shouldTakeScreenshotsAfterStepFailure() {
        return config.getBoolean(SCREENSHOTS_AFTER_STEP_FAILURE);
    }

    @Generated
    private SeleniumDriverConfigHelper() {
    }
}

