/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.config.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.model.error.ConfigurationError;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class ConfigMap
extends HashMap<String, Object> {
    private static final ErrorLogCollection ERROR_LOG_COLLECTION = ErrorLogCollection.getInstance();
    private final transient DocumentContext documentContext;
    private final String location;

    private Object getValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            value = this.getStringFromSystemProperty(key);
        }
        if (value == null || value.equals("")) {
            value = this.getStringFromEnvironment(key);
        }
        if (value == null || value.equals("")) {
            value = this.documentContext.read("$." + key, new Predicate[0]);
        }
        return value;
    }

    private <T> T getValue(String key, Class<T> clazz) {
        Object value = this.getValue(key);
        if (value != null) {
            try {
                return clazz.cast(value);
            }
            catch (ClassCastException exception) {
                QtafFactory.getLogger().error(String.format("Value '%s' of key '%s' could not be parsed as %s", value, key, clazz.getName()), new Object[0]);
                ERROR_LOG_COLLECTION.addErrorLog(new ConfigurationError(exception));
            }
        }
        return null;
    }

    public String getString(String key) {
        try {
            return this.getValue(key, String.class);
        }
        catch (PathNotFoundException exception) {
            this.logMissingKey(key);
            return null;
        }
    }

    public String getString(String key, String valueIfNull) {
        String value = this.getString(key);
        return value != null ? value : valueIfNull;
    }

    public String getStringFromEnvironment(String key) {
        String environmentVariable = this.keyAsEnvironmentVariable(key);
        String s = System.getenv(environmentVariable);
        if (s == null) {
            s = System.getenv(environmentVariable.toLowerCase());
        }
        return s;
    }

    private String keyAsEnvironmentVariable(String key) {
        return key.trim().replace('.', '_').toUpperCase();
    }

    public String getStringFromSystemProperty(String key) {
        return System.getProperty(key);
    }

    public void setString(String key, String value) {
        this.put(key, value);
    }

    public Integer getInt(String key) {
        try {
            return this.getValue(key, Integer.class);
        }
        catch (PathNotFoundException exception) {
            this.logMissingKey(key);
            return null;
        }
    }

    public Integer getInt(String key, Integer valueIfNull) {
        Integer value = this.getInt(key);
        return value == null ? valueIfNull : value;
    }

    public void setInt(String key, Integer value) {
        this.put(key, value);
    }

    public Double getDouble(String key) {
        try {
            return this.getValue(key, Double.class);
        }
        catch (PathNotFoundException exception) {
            this.logMissingKey(key);
            return null;
        }
    }

    public Double getDouble(String key, Double valueIfNull) {
        Double value = this.getDouble(key);
        return value == null ? valueIfNull : value;
    }

    public void setDouble(String key, Double value) {
        this.put(key, value);
    }

    public Boolean getBoolean(String key) {
        try {
            Object value = this.getValue(key);
            if (value instanceof String) {
                String s = (String)value;
                if (Stream.of("1", "true", "y").anyMatch(v -> v.equalsIgnoreCase(s))) {
                    return true;
                }
                if (Stream.of("0", "false", "n").anyMatch(v -> v.equalsIgnoreCase(s))) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                Integer n = (Integer)value;
                if (n == 0) {
                    return false;
                }
                if (n == 1) {
                    return true;
                }
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return b;
            }
        }
        catch (PathNotFoundException | NullPointerException exception) {
            this.logMissingKey(key);
        }
        return null;
    }

    public Boolean getBoolean(String key, Boolean valueIfNull) {
        Boolean value = this.getBoolean(key);
        return value == null ? valueIfNull : value;
    }

    public void setBoolean(String key, Boolean value) {
        this.put(key, value);
    }

    public List<JsonElement> getList(String key) {
        Object value = null;
        try {
            value = this.getValue(key);
            if (value != null) {
                return ((JsonArray)GsonFactory.getInstanceWithoutCustomSerializers().fromJson(value.toString(), JsonArray.class)).asList();
            }
        }
        catch (PathNotFoundException exception) {
            this.logMissingKey(key);
        }
        catch (JsonSyntaxException exception) {
            QtafFactory.getLogger().error(String.format("Value '%s' of key '%s' could not be parsed as a list (%s)", new Object[]{value, key, exception}), new Object[0]);
            ERROR_LOG_COLLECTION.addErrorLog(new ConfigurationError(exception));
        }
        return Collections.emptyList();
    }

    public Map<String, JsonElement> getMap(String key) {
        Object value = null;
        try {
            value = this.getValue(key);
            if (value != null) {
                return ((JsonObject)GsonFactory.getInstanceWithoutCustomSerializers().fromJson(value.toString(), JsonObject.class)).asMap();
            }
        }
        catch (PathNotFoundException exception) {
            this.logMissingKey(key);
        }
        catch (JsonSyntaxException exception) {
            QtafFactory.getLogger().error(String.format("Value '%s' of key '%s' could not be parsed as a JSON object (%s)", new Object[]{value, key, exception}), new Object[0]);
            ERROR_LOG_COLLECTION.addErrorLog(new ConfigurationError(exception));
        }
        return Collections.emptyMap();
    }

    private void logMissingKey(String key) {
        QtafFactory.getLogger().warn(String.format("Failed to find key '%s' in JVM arguments (-D%s), environment variables (%s) or configuration file %s", key, key, this.keyAsEnvironmentVariable(key), this.location), new Object[0]);
    }

    public final <T> T logMissingValue(String key, T fallbackValue) {
        QtafFactory.getLogger().warn(String.format("Value for '%s' was null, defaulting to '%s'.", key, fallbackValue), new Object[0]);
        return fallbackValue;
    }

    @SafeVarargs
    public final <T> T logUnknownValue(String key, T unknownValue, T fallbackValue, T ... knownValues) {
        if (knownValues.length == 0) {
            QtafFactory.getLogger().error(String.format("Unknown value for '%s': '%s'. Defaulting to '%s'.", key, unknownValue, fallbackValue), new Object[0]);
        } else {
            QtafFactory.getLogger().error(String.format("Unknown value for '%s': '%s' (known values: '%s'). Defaulting to '%s'.", key, unknownValue, Arrays.toString(knownValues), fallbackValue), new Object[0]);
        }
        return fallbackValue;
    }

    @Generated
    public ConfigMap(DocumentContext documentContext, String location) {
        this.documentContext = documentContext;
        this.location = location;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigMap)) {
            return false;
        }
        ConfigMap other = (ConfigMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigMap;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }
}

