/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.events.payload;

import de.qytera.qtaf.core.events.payload.MethodInfoEntity;
import de.qytera.qtaf.core.events.payload.QtafTestEventPayload;
import de.qytera.qtaf.core.reflection.ClassHelper;
import de.qytera.qtaf.testng.helper.TestResultHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class TestNGTestEventPayload
extends QtafTestEventPayload {
    protected ITestResult originalEvent;

    public TestNGTestEventPayload(ITestResult iTestResult) throws NoSuchMethodException {
        Class realClass;
        this.originalEvent = iTestResult;
        this.originalTestInstance = iTestResult.getInstance();
        this.instanceId = iTestResult.id();
        this.realClass = realClass = iTestResult.getTestClass().getRealClass();
        this.realClassAnnotations = realClass.getAnnotations();
        this.handleTestNGTestResultObject(iTestResult);
        this.abstractScenarioId = TestResultHelper.getTestMethodId(iTestResult);
        this.instanceId = iTestResult.id();
        this.scenarioId = this.abstractScenarioId + "-" + this.instanceId;
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
        this.handleTestNGMethodObject(iTestResult.getMethod());
        this.featureClassName = realClass.getName();
        this.featurePackageName = realClass.getPackageName();
        this.scenarioMethodName = iTestResult.getMethod().getMethodName();
        this.methodInfo = this.getMethodInfoEntity(iTestResult, realClass);
        this.handleMethodInfo(this.getMethodInfoEntity(iTestResult, realClass));
        Test testNGTestAnnotation = this.getTestAnnotation(this.methodInfo.getMethod());
        assert (testNGTestAnnotation != null);
        this.handleTestNGTestAnnotation(testNGTestAnnotation);
    }

    private void handleTestNGTestResultObject(ITestResult iTestResult) {
        this.featureId = iTestResult.getTestClass().getRealClass().getName();
        this.scenarioStart = new Date(iTestResult.getStartMillis());
        this.scenarioEnd = new Date(iTestResult.getEndMillis());
    }

    private void handleTestNGMethodObject(ITestNGMethod testNGMethod) {
        this.scenarioDescription = testNGMethod.getDescription();
        this.groupDependencies = testNGMethod.getGroupsDependedUpon();
        this.methodDependencies = testNGMethod.getMethodsDependedUpon();
    }

    private MethodInfoEntity getMethodInfoEntity(ITestResult iTestResult, Class<?> clazz) throws NoSuchMethodException {
        Method method;
        String methodName = iTestResult.getName();
        Object[] methodParamValues = iTestResult.getParameters();
        Class[] methodParamTypes = new Class[methodParamValues.length];
        for (int i = 0; i < methodParamValues.length; ++i) {
            methodParamTypes[i] = methodParamValues[i].getClass();
        }
        try {
            method = clazz.getMethod(methodName, methodParamTypes);
        }
        catch (NoSuchMethodException e) {
            List<Method> suitableMethods = ClassHelper.findSuitableMethods(clazz, methodParamValues, methodName);
            if (suitableMethods.isEmpty()) {
                throw e;
            }
            method = suitableMethods.get(0);
        }
        Annotation[] annotations = method.getAnnotations();
        return new MethodInfoEntity(method, methodParamTypes, methodParamValues, annotations);
    }

    private void handleMethodInfo(MethodInfoEntity methodInfo) {
        this.scenarioParameters = methodInfo.getMethod().getParameters();
        this.parameterValues = methodInfo.getMethodParamValues();
    }

    private Test getTestAnnotation(Method method) {
        return method.getAnnotation(Test.class);
    }

    private void handleTestNGTestAnnotation(Test testAnnotation) {
        this.scenarioName = testAnnotation.testName();
    }

    public ITestResult getOriginalEvent() {
        return this.originalEvent;
    }

    public TestNGTestEventPayload setOriginalEvent(ITestResult originalEvent) {
        this.originalEvent = originalEvent;
        return this;
    }

    @Override
    public MethodInfoEntity getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public TestNGTestEventPayload setMethodInfo(MethodInfoEntity methodInfo) {
        this.methodInfo = methodInfo;
        return this;
    }
}

