/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testng.context;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.QtafInitializer;
import de.qytera.qtaf.core.config.annotations.TestFeature;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.context.TestContextHelper;
import de.qytera.qtaf.core.guice.QtafModule;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.selenium.DriverFactory;
import de.qytera.qtaf.testng.event_listener.TestNGEventListener;
import org.openqa.selenium.WebDriver;
import org.testng.annotations.Guice;
import org.testng.annotations.Listeners;

@Listeners(value={TestNGEventListener.class})
@Guice(modules={QtafModule.class})
public abstract class QtafTestNGContext
implements IQtafTestContext {
    public static ConfigMap config;
    public static WebDriver driver;
    public static final TestSuiteLogCollection testSuiteLogCollection;
    protected TestFeature testFeatureAnnotation;
    protected TestFeatureLogCollection testFeatureLogCollection = null;
    protected TestScenarioLogCollection logCollection;
    private boolean isInitialized = false;

    protected QtafTestNGContext() {
        this.initialize();
    }

    @Override
    public QtafTestNGContext initialize() {
        if (this.isInitialized) {
            return this;
        }
        QtafInitializer.initialize();
        config = QtafFactory.getConfiguration();
        driver = QtafFactory.getWebDriver();
        this.testFeatureAnnotation = this.getClass().getAnnotation(TestFeature.class);
        this.isInitialized = true;
        return this;
    }

    @Override
    public void restartDriver() {
        driver = DriverFactory.getDriver(true);
    }

    @Override
    public TestScenarioLogCollection getLogCollection() {
        return this.logCollection;
    }

    @Override
    public QtafTestNGContext setLogCollection(TestScenarioLogCollection collection) {
        this.logCollection = collection;
        return this;
    }

    @Override
    public void addLoggerToFieldsRecursively() {
        TestContextHelper.addLoggerToFieldsRecursively(this);
    }

    static {
        driver = null;
        testSuiteLogCollection = QtafFactory.getTestSuiteLogCollection();
    }
}

