/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.cucumber.context;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.QtafInitializer;
import de.qytera.qtaf.core.config.annotations.TestFeature;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.config.helper.QtafTestExecutionConfigHelper;
import de.qytera.qtaf.core.context.IQtafTestContext;
import de.qytera.qtaf.core.context.TestContextHelper;
import de.qytera.qtaf.core.guice.QtafModule;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.selenium.DriverFactory;
import de.qytera.qtaf.cucumber.entity.QTAFCucumberScenarioEntity;
import de.qytera.qtaf.cucumber.entity.QTAFCucumberScenarioEntityFactory;
import de.qytera.qtaf.testng.event_listener.TestNGEventListener;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.Scenario;
import io.cucumber.testng.AbstractTestNGCucumberTests;
import io.cucumber.testng.FeatureWrapper;
import io.cucumber.testng.PickleWrapper;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestNGEventListener.class})
@Guice(modules={QtafModule.class})
public class QtafTestNGCucumberContext
extends AbstractTestNGCucumberTests
implements IQtafTestContext {
    private static final Logger logger = QtafFactory.getLogger();
    public static ConfigMap config;
    public static WebDriver driver;
    protected TestFeature testFeatureAnnotation;
    public static final TestSuiteLogCollection testSuiteLogCollection;
    private boolean isInitialized = false;
    protected TestScenarioLogCollection logCollection;
    protected TestFeatureLogCollection testFeatureLogCollection = null;

    public QtafTestNGCucumberContext() {
        this.initialize();
    }

    public QtafTestNGCucumberContext(boolean shallInitialize) {
        if (shallInitialize) {
            this.initialize();
        }
    }

    @Override
    public void restartDriver() {
        driver = DriverFactory.getDriver(true);
    }

    @Override
    public final QtafTestNGCucumberContext initialize() {
        if (this.isInitialized) {
            return this;
        }
        QtafInitializer.initialize();
        config = QtafFactory.getConfiguration();
        driver = QtafFactory.getWebDriver();
        this.testFeatureAnnotation = this.getClass().getAnnotation(TestFeature.class);
        if (this.testFeatureAnnotation != null) {
            String testId = this.getClass().getName();
            this.testFeatureLogCollection = TestFeatureLogCollection.createFeatureLogCollectionIfNotExists(testId, this.testFeatureAnnotation);
            testSuiteLogCollection.addTestClassLogCollection(this.testFeatureLogCollection);
        }
        this.isInitialized = true;
        return this;
    }

    @Override
    public TestScenarioLogCollection getLogCollection() {
        return this.logCollection;
    }

    @Override
    public IQtafTestContext setLogCollection(TestScenarioLogCollection collection) {
        this.logCollection = collection;
        return this;
    }

    @Override
    public void addLoggerToFieldsRecursively() {
        TestContextHelper.addLoggerToFieldsRecursively(this);
    }

    @Before
    public void initializeTest(Scenario scenario) {
        logger.debug("-- Cucumber: @Before", new Object[0]);
    }

    public boolean shallRun(QTAFCucumberScenarioEntity scenarioEntity) {
        List<String> configGroups = QtafTestExecutionConfigHelper.getTestGroupsFromConfiguration();
        return configGroups == null || scenarioEntity.hasAnyGroupName(configGroups) || scenarioEntity.belongsToAnyTestSet(configGroups);
    }

    @DataProvider(parallel=false)
    public Object[][] scenarios() {
        Object[][] scenarios = super.scenarios();
        ArrayList<Object[]> filteredScenarios = new ArrayList<Object[]>();
        for (Object[] o : scenarios) {
            QTAFCucumberScenarioEntity scenarioEntity = QTAFCucumberScenarioEntityFactory.getEntity((PickleWrapper)o[0], (FeatureWrapper)o[1]);
            if (!this.shallRun(scenarioEntity)) continue;
            filteredScenarios.add(o);
        }
        Object[][] results = new Object[filteredScenarios.size()][2];
        for (int i = 0; i < filteredScenarios.size(); ++i) {
            results[i] = (Object[])filteredScenarios.get(i);
        }
        return results;
    }

    @Test(groups={"cucumber"}, description="Runs Cucumber Scenarios", dataProvider="scenarios")
    public void runScenario(PickleWrapper pickleWrapper, FeatureWrapper featureWrapper) {
        QTAFCucumberScenarioEntity scenarioEntity = QTAFCucumberScenarioEntityFactory.getEntity(pickleWrapper, featureWrapper);
        this.onBeforeScenario(scenarioEntity);
        super.runScenario(pickleWrapper, featureWrapper);
    }

    protected void onBeforeScenario(QTAFCucumberScenarioEntity scenarioEntity) {
        if (scenarioEntity.getFeatureTags().get("newDriver") != null) {
            this.restartDriver();
        } else if (scenarioEntity.getScenarioTags().get("newDriver") != null) {
            this.restartDriver();
        }
    }

    @BeforeStep
    public void beforeStep(Scenario scenario) {
        logger.debug("-- Cucumber: @BeforeStep - " + scenario.getName() + " : " + scenario.getId(), new Object[0]);
    }

    @AfterStep
    public void afterStep(Scenario scenario) {
        logger.debug("-- Cucumber: @AfterStep - " + scenario.getName() + " : " + scenario.getId(), new Object[0]);
    }

    @After
    public void embedScreenshot(Scenario scenario) {
        logger.debug("-- Cucumber: @After - " + scenario.getName() + " : " + scenario.getId(), new Object[0]);
    }

    static {
        driver = null;
        testSuiteLogCollection = QtafFactory.getTestSuiteLogCollection();
    }
}

