/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium.helper;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import java.net.MalformedURLException;
import java.net.URL;

public class SeleniumDriverConfigHelper {
    public static final String DRIVER_IMPLICIT_WAIT_TIMEOUT = "driver.implicitWaitTimeout";
    public static final String DRIVER_REMOTE_URL = "driver.remoteUrl";
    public static final String DRIVER_PLATFORM = "driver.platform";
    public static final String DRIVER_VERSION = "driver.version";
    public static final String DRIVER_QUIT_AFTER_TESTING = "driver.quitAfterTesting";
    public static final String SCREENSHOTS_BEFORE_SCENARIO = "driver.screenshots.beforeScenario";
    public static final String SCREENSHOTS_AFTER_SCENARIO = "driver.screenshots.afterScenario";
    public static final String SCREENSHOTS_BEFORE_STEP = "driver.screenshots.beforeStep";
    public static final String SCREENSHOTS_AFTER_STEP = "driver.screenshots.afterStep";
    public static final String SCREENSHOTS_AFTER_STEP_FAILURE = "driver.screenshots.afterStepFailure";
    public static final String SAUCE_USERNAME = "sauce.username";
    public static final String SAUCE_ACCESS_KEY = "sauce.accessKey";
    public static final String SAUCE_BROWSER_NAME = "sauce.browserName";
    private static ConfigMap config = QtafFactory.getConfiguration();

    public static int getImplicitTimeout() {
        return config.getInt(DRIVER_IMPLICIT_WAIT_TIMEOUT, 30);
    }

    public static URL getRemoteUrl() {
        try {
            return new URL(config.getString(DRIVER_REMOTE_URL));
        }
        catch (MalformedURLException e) {
            QtafFactory.getLogger().fatal("The given driver url is malformed", new Object[0]);
            System.exit(1);
            return null;
        }
    }

    public static String getPlatformName() {
        return config.getString(DRIVER_PLATFORM);
    }

    public static String getDriverVersion() {
        return config.getString(DRIVER_VERSION);
    }

    public static String getSaucelabBrowserName() {
        return config.getString(SAUCE_BROWSER_NAME);
    }

    public static String getSaucelabUsername() {
        return config.getString(SAUCE_USERNAME);
    }

    public static String getSaucelabAccessKey() {
        return config.getString(SAUCE_ACCESS_KEY);
    }

    public static boolean shouldQuitDriverAfterTesting() {
        return config.getBoolean(DRIVER_QUIT_AFTER_TESTING);
    }

    public static boolean shouldTakeScreenshotsBeforeScenario() {
        return config.getBoolean(SCREENSHOTS_BEFORE_SCENARIO);
    }

    public static boolean shouldTakeScreenshotsAfterScenario() {
        return config.getBoolean(SCREENSHOTS_AFTER_SCENARIO);
    }

    public static boolean shouldTakeScreenshotsBeforeStep() {
        return config.getBoolean(SCREENSHOTS_BEFORE_STEP);
    }

    public static boolean shouldTakeScreenshotsAfterStep() {
        return config.getBoolean(SCREENSHOTS_AFTER_STEP);
    }

    public static boolean shouldTakeScreenshotsAfterStepFailure() {
        return config.getBoolean(SCREENSHOTS_AFTER_STEP_FAILURE);
    }

    private SeleniumDriverConfigHelper() {
    }
}

