/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.selenium;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.selenium.helper.SeleniumDriverConfigHelper;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class AbstractDriver {
    protected static final ConfigMap CONFIG = QtafFactory.getConfiguration();
    protected static final Logger LOGGER = QtafFactory.getLogger();

    public abstract String getName();

    public final WebDriver getDriverInstance() {
        WebDriver driver = this.getDriver();
        if (this.isRemoteDriver()) {
            ((RemoteWebDriver)driver).setFileDetector((FileDetector)new LocalFileDetector());
        }
        return driver;
    }

    protected abstract WebDriver getDriver();

    static void logInfo(String message) {
        LOGGER.info("[DriverFactory] " + message, new Object[0]);
    }

    protected abstract Capabilities getCapabilities();

    protected void initWebDriverManager(WebDriverManager webDriverManager) {
        this.setDriverVersion(webDriverManager);
        webDriverManager.setup();
    }

    protected void setDriverVersion(WebDriverManager webDriverManager) {
        if (SeleniumDriverConfigHelper.getDriverVersion() != null) {
            webDriverManager.driverVersion(SeleniumDriverConfigHelper.getDriverVersion());
        }
    }

    protected abstract boolean isRemoteDriver();
}

