/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.NullType;

public class ClassHelper {
    public static Set<Class<?>> getSuperclasses(Object object, Class<?> stopAt) {
        HashSet set = new HashSet();
        for (Class<?> clazz = object.getClass().getSuperclass(); clazz != null && !stopAt.equals(clazz); clazz = clazz.getSuperclass()) {
            set.add(clazz);
        }
        return set;
    }

    public static Set<Class<?>> getSuperclasses(Object object) {
        return ClassHelper.getSuperclasses(object, NullType.class);
    }

    public static Set<Class<?>> getInterfaces(Object object) {
        Set<Class<?>> superclasses = ClassHelper.getSuperclasses(object);
        HashSet allInterfaces = new HashSet(List.of(object.getClass().getInterfaces()));
        for (Class<?> sc : superclasses) {
            Class<?>[] interfaces = sc.getInterfaces();
            allInterfaces.addAll(Arrays.asList(interfaces));
        }
        return allInterfaces;
    }

    public static Set<Class<?>> getSuperclassesAndInterfaces(Object object) {
        Set<Class<?>> superclasses = ClassHelper.getSuperclasses(object);
        Set<Class<?>> interfaces = ClassHelper.getInterfaces(object);
        superclasses.addAll(interfaces);
        return superclasses;
    }

    public static boolean parametersSuitableForMethod(Method m, Object[] params) {
        Class<?>[] paramTypes = m.getParameterTypes();
        if (params.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].isInstance(params[i])) continue;
            return false;
        }
        return true;
    }

    public static List<Method> findSuitableMethods(Class<?> clazz, Object[] params, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (methodName != null && !methodName.equals(m.getName()) || !ClassHelper.parametersSuitableForMethod(m, params)) continue;
            methods.add(m);
        }
        return methods;
    }

    private ClassHelper() {
    }
}

