/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.log.model.message;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.error.ThrowableWrapper;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.lang.model.type.NullType;

public class StepInformationLogMessage
extends LogMessage {
    private final UUID uuid = UUID.randomUUID();
    private static final String TYPE = "STEP_LOG";
    private String methodName = "";
    private final Step step = new Step();
    private Status status = Status.PENDING;
    private Date start = null;
    private Date end = null;
    private List<StepParameter> stepParameters = new ArrayList<StepParameter>();
    private Object result = null;
    private String screenshotBefore = "";
    private String screenshotAfter = "";
    private ThrowableWrapper error = null;

    public StepInformationLogMessage(String methodName, String message) {
        super(LogLevel.INFO, message);
        this.methodName = methodName;
    }

    protected void finalize() throws Throwable {
        QtafFactory.getLogger().warn("[StepLog] Destroying log message '" + this.getMessage() + "'", new Object[0]);
        super.finalize();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Step getStep() {
        return this.step;
    }

    public StepInformationLogMessage setStep(de.qytera.qtaf.core.guice.annotations.Step step) {
        this.step.setName(step.name());
        this.step.setDescription(step.description());
        return this;
    }

    public <T> void addStepParameter(String name, T value) {
        String className = value == null ? NullType.class.getName() : value.getClass().getSimpleName();
        this.stepParameters.add(new StepParameter(name, className, value));
    }

    public Status getStatus() {
        return this.status;
    }

    public Object getResult() {
        return this.result;
    }

    public StepInformationLogMessage setResult(Object result) {
        this.result = result;
        this.status = Status.PASS;
        return this;
    }

    public ThrowableWrapper getError() {
        return this.error;
    }

    public StepInformationLogMessage setError(Throwable error) {
        this.error = new ThrowableWrapper(error);
        this.status = Status.ERROR;
        return this;
    }

    public StepInformationLogMessage setError(ThrowableWrapper error) {
        this.error = error;
        this.status = Status.ERROR;
        return this;
    }

    public String getTYPE() {
        return TYPE;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public StepInformationLogMessage setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public StepInformationLogMessage setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Date getStart() {
        return this.start;
    }

    public StepInformationLogMessage setStart(Date start) {
        this.start = start;
        return this;
    }

    public Date getEnd() {
        return this.end;
    }

    public StepInformationLogMessage setEnd(Date end) {
        this.end = end;
        return this;
    }

    public long getDuration() {
        if (this.end != null && this.getStart() != null) {
            return this.end.getTime() - this.getStart().getTime();
        }
        return 0L;
    }

    public String getScreenshotBefore() {
        return this.screenshotBefore;
    }

    public StepInformationLogMessage setScreenshotBefore(String screenshotBefore) {
        this.screenshotBefore = screenshotBefore;
        return this;
    }

    public String getScreenshotAfter() {
        return this.screenshotAfter;
    }

    public StepInformationLogMessage setScreenshotAfter(String screenshotAfter) {
        this.screenshotAfter = screenshotAfter;
        return this;
    }

    public List<StepParameter> getStepParameters() {
        return this.stepParameters;
    }

    public void setStepParameters(List<StepParameter> stepParameters) {
        this.stepParameters = stepParameters;
    }

    public static class Step {
        private String name = "";
        private String description = "";

        public String getName() {
            return this.name;
        }

        public Step setName(String name) {
            this.name = name;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Step setDescription(String description) {
            this.description = description;
            return this;
        }
    }

    public static enum Status {
        PENDING,
        PASS,
        ERROR,
        SKIPPED,
        UNDEFINED;

    }

    public static class StepParameter {
        private String name;
        private String type;
        private Object value;

        public StepParameter(String name, String type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public StepParameter setName(String name) {
            this.name = name;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public StepParameter setType(String type) {
            this.type = type;
            return this;
        }

        public Object getValue() {
            return this.value;
        }

        public StepParameter setValue(Object value) {
            this.value = value;
            return this;
        }
    }
}

