/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.gson;

import com.google.gson.Gson;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.io.FileHelper;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import java.io.IOException;

public class GsonHelper {
    private static final Gson gson = GsonFactory.getInstance();

    public static <T> T fromJson(String json, Class<T> tClass) {
        return (T)gson.fromJson(json, tClass);
    }

    public static <T> void saveJsonFile(T entity, String filePath) {
        Gson gson = GsonFactory.getInstance();
        String json = gson.toJson(entity);
        try {
            FileHelper.createFileIfNotExists((String)DirectoryHelper.preparePath((String)filePath), (String)json);
        }
        catch (IOException e) {
            ErrorLogCollection errors = ErrorLogCollection.getInstance();
            ErrorLog error = new ErrorLog(e);
            errors.addErrorLog(error);
        }
    }

    private GsonHelper() {
    }
}

