/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.events.EventListenerInitializer;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.log.model.error.FrameworkInitializationErrorLog;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class QtafInitializer {
    private static boolean isInitialized = false;
    private static final ErrorLogCollection errorLogs = ErrorLogCollection.getInstance();

    private QtafInitializer() {
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            EventListenerInitializer.initialize();
            QtafEvents.eventListenersInitialized.onNext(null);
            QtafEvents.eventListenersInitialized.onCompleted();
        }
        catch (Exception e) {
            QtafEvents.eventListenersInitialized.onError((Throwable)e);
            QtafInitializer.handleError(e);
        }
        try {
            QtafInitializer.createDirectories();
        }
        catch (IOException e) {
            QtafInitializer.handleError(e);
        }
        QtafEvents.frameworkInitialized.onNext(null);
        QtafEvents.frameworkInitialized.onCompleted();
        ConfigMap config = QtafFactory.getConfiguration();
        QtafEvents.configurationLoaded.onNext((Object)config);
        QtafEvents.configurationLoaded.onCompleted();
        isInitialized = true;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    private static void createDirectories() throws IOException {
        String userDir = System.getProperty("user.dir");
        String fs = System.getProperty("file.separator");
        Files.createDirectories(Paths.get(userDir + fs + "logs", new String[0]), new FileAttribute[0]);
    }

    private static void handleError(Exception e) {
        errorLogs.addErrorLog(new FrameworkInitializationErrorLog(e));
        QtafEvents.frameworkInitialized.onError((Throwable)e);
        System.exit(1);
    }
}

