/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.aws_devicefarm.driver;

import com.amazonaws.services.devicefarm.AWSDeviceFarm;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClientBuilder;
import com.amazonaws.services.devicefarm.model.CreateTestGridUrlRequest;
import com.amazonaws.services.devicefarm.model.CreateTestGridUrlResult;
import de.qytera.qtaf.aws_devicefarm.config.AWSDeviceFarmConfigHelper;
import de.qytera.qtaf.core.selenium.AbstractDriver;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class AbstractAWSDeviceFarmDriver
extends AbstractDriver {
    public WebDriver getDriver() {
        String myProjectARN = AWSDeviceFarmConfigHelper.getProjectArn();
        AWSDeviceFarmClientBuilder builder = AWSDeviceFarmClient.builder();
        builder.setRegion(AWSDeviceFarmConfigHelper.getProjectRegion());
        AWSDeviceFarm client = (AWSDeviceFarm)builder.build();
        CreateTestGridUrlRequest request = new CreateTestGridUrlRequest();
        request.setExpiresInSeconds(Integer.valueOf(300));
        request.setProjectArn(myProjectARN);
        CreateTestGridUrlResult response = this.getTestGridUrl(client, request);
        URL testGridUrl = null;
        try {
            testGridUrl = new URL(response.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return new RemoteWebDriver(testGridUrl, this.getCapabilities());
    }

    public CreateTestGridUrlResult getTestGridUrl(AWSDeviceFarm client, CreateTestGridUrlRequest request) {
        return client.createTestGridUrl(request);
    }
}

