/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.usecasemaid.serializing;

import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.customtypes.DeserializationOnlyType;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.usecasemaid.serializing.VirtualDeserializer;
import de.quantummaid.usecasemaid.usecasemethod.UseCaseMethod;
import java.util.Map;

public final class UseCaseClassScanner {
    private UseCaseClassScanner() {
    }

    public static void addMethod(UseCaseMethod method, MapMaidBuilder builder) {
        Map<String, ResolvedType> parameters = method.parameters();
        parameters.values().stream().map(GenericType::fromResolvedType).forEach(type -> builder.withType(type, RequiredCapabilities.deserialization(), String.format("because parameter type of method %s", method.describe())));
        method.returnType().ifPresent(type -> {
            GenericType genericType = GenericType.fromResolvedType((ResolvedType)type);
            builder.withType(genericType, RequiredCapabilities.serialization(), String.format("because return type of method %s", method.describe()));
        });
        DeserializationOnlyType<?> virtualType = UseCaseClassScanner.createVirtualObjectFor(method.describe(), parameters);
        builder.deserializing(virtualType);
    }

    private static DeserializationOnlyType<?> createVirtualObjectFor(String method, Map<String, ResolvedType> parameters) {
        TypeIdentifier typeIdentifier = TypeIdentifier.uniqueVirtualTypeIdentifier();
        SerializedObjectDeserializer deserializer = VirtualDeserializer.virtualDeserializerFor(method, parameters);
        return DeserializationOnlyType.deserializationOnlyType((TypeIdentifier)typeIdentifier, (TypeDeserializer)deserializer);
    }
}

